<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Tiles extends \Bricks\Element {
    public $category     = 'Next Bricks - Backgrounds';
    public $name         = 'next_tiles';
    public $icon         = 'ion-md-grid';
    public $tag      = 'div';
    public $scripts      = ['next_tiles'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Tiles', 'bricks' );
    }

    public function set_controls() {
      $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
          'div' => 'div',
          'section' => 'section',
          'article' => 'article',
          'aside' => 'aside',
          'header' => 'header',
          'footer' => 'footer',
          'main' => 'main',
          'nav' => 'nav',
          'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'div',
        'default'     => 'div',
    ];
    $this->controls['customTag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Custom tag', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'placeholder' => 'div',
        'required'    => [ 'tag', '=', 'custom' ],
    ];
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Tiles is a nestable block element. You can put any elements at it and edit its display settings at the Style tab.', 'bricks' )))
        ];

        /*Block*/
        $this->controls['blockSeparator'] = [
            'label'      => esc_html__( 'Block style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['width'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'width',
                'selector' => '',
              ]
            ],
            'placeholder' => '400px',
            'default' => '400px',
        ];
        $this->controls['height'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'height',
                'selector' => '',
              ]
            ],
            'placeholder' => '400px',
            'default' => '400px',
        ];
        $this->controls['offset'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Offset', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => '--offset',
                'selector' => '',
              ]
            ],
            'placeholder' => '20px',
            'default' => '20px',
        ];
        $this->controls['background'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type' => 'background',
            'inline' => true,
            'css' => [
              [
                'property' => 'background',
                'selector' => '',
              ]
            ],
        ];
        $this->controls['border'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'inline' => true,
            'css' => [
              [
                'property' => 'border',
                'selector' => '',
              ]
            ],
            'default' => [
                'width' => [
                  'top' => 1,
                  'right' => 1,
                  'bottom' => 1,
                  'left' => 1,
                ],
                'style' => 'solid',
                'color' => [
                  'rgb' => 'rgba(229, 229, 229, 1)',
                ],
                'radius' => [
                  'top' => 16,
                  'right' => 16,
                  'bottom' => 16,
                  'left' => 16,
                ],
            ],
        ];

        /*Square*/
        $this->controls['tilesSeparator'] = [
            'label'      => esc_html__( 'Tiles', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['SQUAREdimensions'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Dimensions', 'bricks' ),
            'type'  => 'number',
            'units'  => true,
            'inline' => true,
            'placeholder' => '50px',
        ];
        $this->controls['SQUAREborder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'inline' => true,
            'css' => [
              [
                'property' => 'border',
                'selector' => '.next-tiles__square',
              ]
            ],
            'default' => [
                'width' => [
                  'top' => 0.5,
                  'right' => 0.5,
                  'bottom' => 0.5,
                  'left' => 0.5,
                ],
                'style' => 'solid',
                'color' => [
                  'rgb' => 'rgba(229, 229, 229, 1)',
                ],
            ],
        ];
        $this->controls['SQUAREenterColor'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Enter Color', 'bricks' ),
            'type'  => 'color',
            'inline' => true,
            'css' => [
              [
                'property' => '--mouseenter-color',
                'selector' => '',
              ]
            ],
            'default' => [
                'rgb' => 'rgba(236, 236, 236, 1)',
            ],
        ];
        $this->controls['SQUAREleaveColor'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Leave Color', 'bricks' ),
            'type'  => 'color',
            'inline' => true,
            'css' => [
              [
                'property' => '--mouseleave-color',
                'selector' => '',
              ]
            ],
            'default' => [
                'rgb' => 'rgba(129, 129, 129, 1)',
            ],
        ];
        $this->controls['SQUAREduration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type'  => 'number',
            'unit'  => 's',
            'inline' => true,
            'css' => [
              [
                'property' => '--duration',
                'selector' => '',
              ]
            ],
            'placeholder' => '0.2s',
            'default' => '0.2s',
        ];
        $this->controls['SQUAREeasing'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'CSS Easing', 'bricks' ),
            'type'  => 'text',
            'inline' => true,
            'css' => [
              [
                'property' => '--easing',
                'selector' => '',
              ]
            ],
            'placeholder' => 'ease-in-out',
            'default' => 'ease-in-out',
        ];
    }

    public function get_nestable_children() {
      return [
          [
              'name'     => 'block',
              'label'    => esc_html__( 'Content', 'bricks' ),
              'settings' => [
                  '_hidden'  => [
                      '_cssClasses' => 'next-tiles__content-new',
                  ],
              ],
              'children' => [
                  [
                    'name'     => 'heading',
                    'label'    => esc_html__( 'Heading', 'bricks' ),
                    'settings' => [
                        'text' => esc_html__( 'Tiles', 'bricks' ),
                    ],
                  ]
              ]
          ],
      ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_tiles', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_tiles.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
    $settings = $this->settings;
    $is_builder = bricks_is_builder();
        $SQUAREdimensions = ! empty( $settings['SQUAREdimensions'] ) ? $settings['SQUAREdimensions'] : 40;

        $this->set_attribute( '_root', 'class', "next-tiles");
        $this->set_attribute( '_root', 'data-square-dimensions', $SQUAREdimensions);
        if ( ! $is_builder ) {
            $this->set_attribute( '_root', 'data-flickering', '1');
        }

        $output = "<{$this->tag} {$this->render_attributes( '_root' )}>";
        $output .= "<div class='next-tiles__squares-layout'></div>";
        $output .= "<div class='next-tiles__content'>";
        $output .= Frontend::render_children($this);
        $output .= "</div>";
        $output .= "</{$this->tag}>";

        echo $output;
    }
}
