<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Tiles_V2 extends \Bricks\Element {
    public $category     = 'Next Bricks - Backgrounds';
    public $name         = 'next_tiles_v2';
    public $icon         = 'ion-md-grid';
    public $tag      = 'div';
    public $scripts      = ['next_tiles_v2'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Tiles v2', 'bricks' );
    }

    public function set_controls() {
      $this->controls['tag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'HTML tag', 'bricks' ),
        'type'        => 'select',
        'options'     => [
          'div' => 'div',
          'section' => 'section',
          'article' => 'article',
          'aside' => 'aside',
          'header' => 'header',
          'footer' => 'footer',
          'main' => 'main',
          'nav' => 'nav',
          'custom' => 'custom',
        ],
        'clearable'   => false,
        'inline'      => true,
        'placeholder' => 'div',
        'default'     => 'div',
    ];
    $this->controls['customTag'] = [
        'tab'         => 'content',
        'label'       => esc_html__( 'Custom tag', 'bricks' ),
        'type'        => 'text',
        'inline'      => true,
        'placeholder' => 'div',
        'required'    => [ 'tag', '=', 'custom' ],
    ];
        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Tiles v2 is a nestable block element. You can put any elements at it and edit its display settings at the Style tab.', 'bricks' )))
        ];

        /*Block*/
        $this->controls['blockSeparator'] = [
            'label'      => esc_html__( 'Block style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['width'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'width',
                'selector' => '',
              ]
            ],
            'default' => '100%',
        ];
        $this->controls['height'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Height', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
              [
                'property' => 'height',
                'selector' => '',
              ]
            ],
            'default' => '500px',
        ];
        $this->controls['background'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Background', 'bricks' ),
            'type' => 'background',
            'inline' => true,
            'css' => [
              [
                'property' => 'background',
                'selector' => '',
              ]
            ],
            'default' => [
                'color' => [
                  'hex' => '#e3e3e3',
                ],
            ],
        ];
        $this->controls['border'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'inline' => true,
            'css' => [
              [
                'property' => 'border',
                'selector' => '',
              ]
            ],
        ];

        $this->controls['tilesSeparator'] = [
            'label'      => esc_html__( 'Tiles', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['tileSize'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Size', 'bricks' ),
            'type'  => 'number',
            'units' => true,
            'default' => 80,
        ];
        $this->controls['tileColor'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Color', 'bricks' ),
            'type'  => 'color',
            'inline' => true,
            'css' => [
              [
                'property' => 'background-color',
                'selector' => '.next-tiles-v2__dot',
              ]
            ],
            'default' => [
                'hex' => '#ffa04f',
            ],
        ];
        $this->controls['tileBorder'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Border', 'bricks' ),
            'type'  => 'border',
            'inline' => true,
            'css' => [
              [
                'property' => 'border',
                'selector' => '.next-tiles-v2__dot',
              ]
            ],
            'default' => [
                'radius' => [
                  'top' => 9999,
                  'right' => 9999,
                  'bottom' => 9999,
                  'left' => 9999,
                ],
            ],
        ];

        $this->controls['animationSeparator'] = [
            'label'      => esc_html__( 'Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['duration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Fade Duration', 'bricks' ),
            'type'  => 'number',
            'unit'  => 's',
            'inline' => true,
            'css' => [
              [
                'property' => '--duration',
                'selector' => '',
              ]
            ],
            'default' => '0.2s',
        ];
        $this->controls['delay'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Fade Delay', 'bricks' ),
            'type'  => 'number',
            'unit'  => 's',
            'inline' => true,
            'default' => '1.2s',
        ];
        $this->controls['easing'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Fade CSS Easing', 'bricks' ),
            'type'  => 'text',
            'css' => [
              [
                'property' => '--easing',
                'selector' => '',
              ]
            ],
            'default' => 'ease',
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Content', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'next-tiles-v2__content',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'heading',
                        'label'    => esc_html__( 'Heading', 'bricks' ),
                        'settings' => [
                            'text' => esc_html__( 'Tiles v2', 'bricks' ),
                            'tag'  => 'h3',
                        ],
                    ]
                ]
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_tiles_v2', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_tiles_v2.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $tileSize = ! empty( $settings['tileSize'] ) ? $settings['tileSize'] : 80;
        $delay = ! empty( $settings['delay'] ) ? $settings['delay'] : 1.2;

        $this->set_attribute( '_root', 'class', "next-tiles-v2");

        $output = "<{$this->tag} {$this->render_attributes( '_root' )}
            data-pixel-size='{$tileSize}'
            data-delay='{$delay}'
        >";
        $output .= "<div class='next-tiles-v2__trail'></div>";
        $output .= Frontend::render_children( $this );
        $output .= "</{$this->tag}>";

        echo $output;
    }
}