<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Timeline extends \Bricks\Element {
    public $category     = 'Next Bricks - Cores';
    public $name         = 'next_timeline';
    public $icon         = 'fas fa-timeline';
    public $scripts      = ['next_timeline'];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Timeline', 'bricks' );
    }

    public function set_controls() {
        $this->controls['note0'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Timeline is a nestable block element. You can put any elements at it or at its children.', 'bricks' )))
        ];
        $this->controls['note1'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Styles from Timeline element and their children can be set at their Style tabs. Timeline item element comes with a grid and a padding already set.', 'bricks' )))
        ];

        /* Items */
        $this->controls['itemsSeparator'] = [
            'label'      => esc_html__( 'Timeline Items', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['_children'] = [
            'type'          => 'repeater',
            'titleProperty' => 'label',
            'items'         => 'children',
        ];

        /* Progress style */
        $this->controls['progressStyleSeparator'] = [
            'label'      => esc_html__( 'Progress', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['progressWidth'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Width', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                    'property' => '--progress-bar',
                    'selector' => '',
                ]
            ],
            'placeholder' => '3px',
        ];
        $this->controls['progressHeight'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Start', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                    'property' => '--progress-start',
                    'selector' => '',
                ]
            ],
            'placeholder' => '50vh',
        ];
        //Gradient
        $this->controls['degree'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Gradient Degree', 'bricks' ),
            'type'    => 'number',
            'unit'    => 'deg',
            'placeholder'    => '180deg',
        ];
        //Gradient
        $this->controls['colors'] = [
            'tab'           => 'content',
            'type'          => 'repeater',
            'label'         => esc_html__( 'Gradient Colors', 'bricks' ),
            'titleProperty' => 'title',
            'fields'        => [
                'gradientcolor'       => [
                    'type'    => 'color',
                    'label'   => esc_html__( 'Color', 'bricks' ),
                ],
            ],
        ];
        $this->controls['progressPathColor'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Path color', 'bricks' ),
            'type' => 'color',
            'inline' => true,
            'css' => [
                [
                    'property' => 'background',
                    'selector' => '.next-timeline--progress',
                ]
            ],
        ];
        $this->controls['fadeEdgesHeight'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Fade edges height', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                    'property' => '--progress-fade-edges-height',
                    'selector' => '',
                ]
            ],
            'placeholder' => '50px',
        ];
        $this->controls['progressLeft'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Left', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                    'property' => 'left',
                    'selector' => '.next-timeline--progress',
                ]
            ],
            'placeholder' => 'auto',
        ];
        $this->controls['progressRight'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Right', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                    'property' => 'right',
                    'selector' => '.next-timeline--progress',
                ]
            ],
            'placeholder' => 'auto',
        ];

        /* Sticky Wrapper */
        $this->controls['stickyWrapperSeparator'] = [
            'label'      => esc_html__( 'Sticky Wrapper style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['stickyTopItem'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Sticky top', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                    'property' => '--sticky-top',
                    'selector' => '',
                ]
            ],
            'placeholder' => '50vh',
        ];
        $this->controls['stickyWrapperWidth'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Center Outline Width', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                    'property' => '--sticky-wrapper-outline-width',
                    'selector' => '.next-timeline--center-section > .next-timeline--sticky-wrapper',
                ]
            ],
            'placeholder' => '8px',
        ];
        $this->controls['stickyWrapperColor'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Center Outline Color', 'bricks' ),
            'type' => 'color',
            'inline' => true,
            'css' => [
                [
                    'property' => '--sticky-wrapper-outline-color',
                    'selector' => '.next-timeline--center-section > .next-timeline--sticky-wrapper',
                ]
            ],
        ];

        /* Circle */
        $this->controls['circleSeparator'] = [
            'label'      => esc_html__( 'Center Circle style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['circleDimensions'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Dimensions', 'bricks' ),
            'type' => 'number',
            'units' => true,
            'inline' => true,
            'css' => [
                [
                    'property' => '--dimensions',
                    'selector' => '.next-timeline--circle',
                ]
            ],
            'placeholder' => '15px',
        ];
        $this->controls['circleColor'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Color', 'bricks' ),
            'type' => 'background',
            'inline' => true,
            'css' => [
                [
                    'property' => 'background',
                    'selector' => '.next-timeline--circle',
                ]
            ],
        ];

        /* Fade Animation */
        $this->controls['fadeAnimationSeparator'] = [
            'label'      => esc_html__( 'Fade Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['enableLeftFade'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Left Section Fade', 'bricks' ),
            'type' => 'checkbox',
            'default' => true,
        ];
        $this->controls['enableCenterFade'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Center Section Fade', 'bricks' ),
            'type' => 'checkbox',
            'default' => true,
        ];
        $this->controls['enableRightFade'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Right Section Fade', 'bricks' ),
            'type' => 'checkbox',
            'default' => true,
        ];
        $this->controls['fromFade'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'From Opacity', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'css' => [
                [
                    'property' => '--from-opacity',
                    'selector' => '',
                ]
            ],
            'placeholder' => '0.25',
        ];
        $this->controls['start'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Start', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => 'top center',
        ];
        $this->controls['end'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'End', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => 'top center-=300',
        ];
        $this->controls['easing'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'GSAP easing', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'none' => 'none',
                'power1' => 'power1',
                'power2' => 'power2',
                'power3' => 'power3',
                'power4' => 'power4',
                'back' => 'back',
                'bounce' => 'bounce',
                'circ' => 'circ',
                'elastic' => 'elastic',
                'expo' => 'expo',
                'sine' => 'sine',
                'steps' => 'steps'
            ],
            'inline' => true,
            'placeholder' => 'power3',
        ];
        $this->controls['scrub'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Scrub', 'bricks' ),
            'type' => 'checkbox',
            'inline' => true,
            'default' => true,
        ];
        $this->controls['duration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => '0.5',
            'required' => [ 'scrub', '=', false],
        ];
        $this->controls['delay'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Delay', 'bricks' ),
            'type' => 'text',
            'inline' => true,
            'placeholder' => '0.2',
            'required' => [ 'scrub', '=', false],
        ];
        $this->controls['toggleActions'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'toggleActions', 'bricks' ),
            'type' => 'text',
            'placeholder' => 'play none none reverse',
            'required' => [ 'scrub', '=', false],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_timeline', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_timeline.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function get_nestable_children() {
		return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Timeline Item', 'bricks' ),
                'settings' => [
                    '_hidden' => [
                    '_cssClasses' => 'next-timeline--item',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Left Section', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'next-timeline--left-section',
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'block',
                                'label'    => esc_html__( 'Sticky Wrapper', 'bricks' ),
                                'settings' => [
                                    '_hidden'  => [
                                        '_cssClasses' => 'next-timeline--sticky-wrapper',
                                    ],
                                ],
                                'children' => [
                                    [
                                        'name'     => 'heading',
                                        'label'    => esc_html__( 'Date', 'bricks' ),
                                        'settings' => [
                                            'text' => esc_html__( 'January 2021', 'bricks' ),
                                            'tag'  => 'h2',
                                        ],
                                    ],
                                ],
                            ],
                        ],
                    ],
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Center Section', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'next-timeline--center-section',
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'block',
                                'label'    => esc_html__( 'Sticky Wrapper', 'bricks' ),
                                'settings' => [
                                    '_hidden'  => [
                                        '_cssClasses' => 'next-timeline--sticky-wrapper',
                                    ],
                                ],
                                'children' => [
                                    [
                                        'name'     => 'block',
                                        'label'    => esc_html__( 'Circle', 'bricks' ),
                                        'settings' => [
                                            '_hidden' => [
                                                '_cssClasses' => 'next-timeline--circle',
                                            ],
                                        ],
                                    ],
                                ],
                            ],
                        ],
                    ],
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Right Section', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'next-timeline--right-section',
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'block',
                                'label'    => esc_html__( 'Sticky Wrapper', 'bricks' ),
                                'settings' => [
                                    '_hidden'  => [
                                        '_cssClasses' => 'next-timeline--sticky-wrapper',
                                    ],
                                ],
                                'children' => [
                                    [
                                        'name'     => 'heading',
                                        'label'    => esc_html__( 'Co-founder', 'bricks' ),
                                        'settings' => [
                                            'text' => esc_html__( 'Co-founder Dan', 'bricks' ),
                                            'tag'  => 'h2',
                                        ],
                                    ],
                                    [
                                        'name'     => 'heading',
                                        'label'    => esc_html__( 'Co-founder', 'bricks' ),
                                        'settings' => [
                                            'text' => esc_html__( 'Co-founder Tim', 'bricks' ),
                                            'tag'  => 'h2',
                                        ],
                                    ],
                                    [
                                        'name'     => 'heading',
                                        'label'    => esc_html__( 'Co-founder', 'bricks' ),
                                        'settings' => [
                                            'text' => esc_html__( 'Co-founder Lisa', 'bricks' ),
                                            'tag'  => 'h2',
                                        ],
                                    ],
                                ],
                            ],
                        ],
                    ],
                ],
            ],
		];
    }

    public function render() {
        $settings = $this->settings;
        $degree = ! empty( $settings['degree'] ) ? $settings['degree'] : '180deg';

        /* Progress gradient */
        $colors = ! empty( $settings['colors'] ) ? $settings['colors'] : '';
        if ($colors) {
            $gradientcolors = '';
            foreach ( $colors as $color ) {
                if ( isset($color['gradientcolor']) && is_array($color['gradientcolor'])) {
                    if (isset($color['gradientcolor']['rgb'])) {
                      $gradientcolor = $color['gradientcolor']['rgb'];
                    }else if(isset($color['gradientcolor']['raw'])){
                      $gradientcolor = $color['gradientcolor']['raw'];
                    }else if(isset($color['gradientcolor']['hex'])){
                      $gradientcolor = $color['gradientcolor']['hex'];
                    }
                    $gradientcolors .= $gradientcolor . 'bc11';
                }else{
                    $gradientcolors .= 'unset' . 'bc11';
                }
            }
            $gradientcolors .= '';
        }else{
            $gradientcolors = 'unset';
        }
        $this->set_attribute( '_root', 'data-gradient-colors', $gradientcolors);
        $this->set_attribute( '_root', 'data-degree', $degree);

        /* JS */
        $enableLeftFade = ! empty( $settings['enableLeftFade'] ) ? $settings['enableLeftFade'] : 0;
        $enableCenterFade = ! empty( $settings['enableCenterFade'] ) ? $settings['enableCenterFade'] : 0;
        $enableRightFade = ! empty( $settings['enableRightFade'] ) ? $settings['enableRightFade'] : 0;
        $start = ! empty( $settings['start'] ) ? $settings['start'] : 'top center';
        $end = ! empty( $settings['end'] ) ? $settings['end'] : 'top center-=300';
        $easing = ! empty( $settings['easing'] ) ? $settings['easing'] : 'power3';
        $scrub = ! empty( $settings['scrub'] ) ? $settings['scrub'] : 0;
        $duration = ! empty( $settings['duration'] ) ? $settings['duration'] : 0.5;
        $delay = ! empty( $settings['delay'] ) ? $settings['delay'] : 0;
        $toggleActions = ! empty( $settings['toggleActions'] ) ? $settings['toggleActions'] : 'play none none reverse';

        $this->set_attribute( '_root', 'data-enable-left-fade', $enableLeftFade );if($enableLeftFade == 1){$this->set_attribute( '_root', 'data-left-fade', "true");}
        $this->set_attribute( '_root', 'data-enable-center-fade', $enableCenterFade );if($enableCenterFade == 1){$this->set_attribute( '_root', 'data-center-fade', "true");}
        $this->set_attribute( '_root', 'data-enable-right-fade', $enableRightFade );if($enableRightFade == 1){$this->set_attribute( '_root', 'data-right-fade', "true");}
        $this->set_attribute( '_root', 'data-start', $start );
        $this->set_attribute( '_root', 'data-end', $end );
        $this->set_attribute( '_root', 'data-easing', $easing );
        $this->set_attribute( '_root', 'data-scrub', $scrub );
        $this->set_attribute( '_root', 'data-duration', $duration );
        $this->set_attribute( '_root', 'data-delay', $delay );
        $this->set_attribute( '_root', 'data-toggle-actions', $toggleActions );

        $this->set_attribute( '_root', 'class', "next-timeline");
        $output = "<div {$this->render_attributes( '_root' )}>";

        $output .= '
        <div class="next-timeline--progress">
            <div class="next-timeline--progress-bar"></div>
        </div>'; 

        $output .= Frontend::render_children( $this );
        $output .= '</div>';

        echo $output;
    }
}