<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Toast extends \Bricks\Element {
    public $category     = 'Next Bricks - Cores';
    public $name         = 'next_toast';
    public $icon         = 'fas fa-bread-slice';
    public $scripts      = ['next_toast'];

    public function get_label() {
        return esc_html__( 'Toast', 'bricks' );
    }

    public function set_controls() {
        $this->controls['toasts'] = [
            'tab' => 'content',
            'label' => esc_html__('Toasts', 'bricks'),
            'type' => 'repeater',
            'titleProperty' => 'title',
            'fields' => [
                'title' => [
                    'label' => esc_html__('Title', 'bricks'),
                    'type' => 'text',
                ],
                'message' => [
                    'label' => esc_html__('Message', 'bricks'),
                    'type' => 'text',
                ],
                'event' => [
                    'label' => esc_html__('Event', 'bricks'),
                    'type' => 'select',
                    'options'     => [
                        'click' => 'click',
                        'pageload' => 'pageload',
                    ],
                    'default' => 'pageload',
                ],
                'showTime' => [
                    'label' => esc_html__('Show Time (seconds)', 'bricks'),
                    'type' => 'number',
                    'default' => 5,
                    'required' => [ 'event', '=', 'pageload' ],
                ],
                'trigger' => [
                    'label' => esc_html__('Trigger', 'bricks'),
                    'type' => 'text',
                    'placeholder' => '.className',
                    'required' => [ 'event', '=', 'click' ],
                ],
            ],
            'default' => [
                [
                    'title' => 'Welcome',
                    'message' => 'Thanks for visiting our site!',
                    'event' => 'pageload',
                    'showTime' => 5,
                    'trigger' => '',
                ]
            ]
        ];

        //Toasts container
        $this->controls['toastsContainerSeparator'] = [
            'label'      => esc_html__( 'Toasts Container', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['toastsContainerWidth'] = [
            'tab' => 'content',
            'label' => esc_html__('Width', 'bricks'),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'width',
                    'selector' => '',
                ],
            ],
            'default' => '300px',
        ];

        $this->controls['toastsContainerHeight'] = [
            'tab' => 'content', 
            'label' => esc_html__('Height', 'bricks'),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'height',
                    'selector' => '',
                ],
            ],
            'default' => 'auto',
        ];

        $this->controls['toastsContainerTop'] = [
            'tab' => 'content',
            'label' => esc_html__('Top', 'bricks'),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'top',
                    'selector' => '',
                ],
            ],
        ];

        $this->controls['toastsContainerLeft'] = [
            'tab' => 'content',
            'label' => esc_html__('Left', 'bricks'),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'left',
                    'selector' => '',
                ],
            ],
        ];

        $this->controls['toastsContainerBottom'] = [
            'tab' => 'content',
            'label' => esc_html__('Bottom', 'bricks'),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'bottom',
                    'selector' => '',
                ],
            ],
            'default' => '20px',
        ];

        $this->controls['toastsContainerRight'] = [
            'tab' => 'content',
            'label' => esc_html__('Right', 'bricks'),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'right',
                    'selector' => '',
                ],
            ],
            'default' => '20px',
        ];

        $this->controls['toastsContainerZIndex'] = [
            'tab' => 'content',
            'label' => esc_html__('Z-Index', 'bricks'),
            'type' => 'number',
            'css' => [
                [
                    'property' => 'z-index',
                    'selector' => '',
                ],
            ],
            'default' => '50',
        ];

        //Toasts style
        $this->controls['toastsStyleSeparator'] = [
            'label'      => esc_html__( 'Toasts Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['toastsPadding'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Padding', 'bricks' ),
            'type'    => 'spacing',
            'css'     => [
                [
                    'property' => 'padding',
                    'selector' => '.next-toast__toast',
                ],
            ],
            'default' => [
                'top'    => 16,
                'right'  => 16, 
                'bottom' => 16,
                'left'   => 16,
            ],
        ];
        $this->controls['toastsBackground'] = [
            'tab' => 'content',
            'label' => esc_html__('Background', 'bricks'),
            'type' => 'background',
            'css' => [
                [
                    'property' => 'background',
                    'selector' => '.next-toast__toast',
                ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#000',
                ],
            ],
        ];
        $this->controls['toastsBorder'] = [
            'tab' => 'content',
            'label' => esc_html__('Border', 'bricks'),
            'type' => 'border',
            'css' => [
                [
                    'property' => 'border',
                    'selector' => '.next-toast__toast',
                ],
            ],
            'default' => [
                'width' => [
                    'top' => 1,
                    'right' => 1,
                    'bottom' => 1,
                    'left' => 1,
                ],
                'color' => [
                    'hex' => '#272729',
                ],
                'style' => 'solid',
                'radius' => [
                  'top' => 10,
                  'right' => 10,
                  'bottom' => 10,
                  'left' => 10,
                ],
            ],
        ];
        $this->controls['toastsContentGap'] = [
            'tab' => 'content',
            'label' => esc_html__('Gap', 'bricks'),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'gap',
                    'selector' => '.next-toast__toast-body',
                ],
            ],
            'default' => '8px',
        ];

        //Title and Message style
        $this->controls['toastsTitleAndMessageStyleSeparator'] = [
            'label'      => esc_html__( 'Title and Message Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['toastsTitleTypography'] = [
            'tab' => 'content',
            'label' => esc_html__('Title Typography', 'bricks'),
            'type' => 'typography',
            'css' => [
                [
                    'property' => 'typography',
                    'selector' => '.next-toast__toast-title',
                ],
            ],
            'default' => [
                'font-size' => '17px',
                'font-weight' => '500',
                'color' => [
                    'hex' => '#ffffff',
                ],
            ],
        ];
        $this->controls['toastsMessageTypography'] = [
            'tab' => 'content', 
            'label' => esc_html__('Message Typography', 'bricks'),
            'type' => 'typography',
            'css' => [
                [
                    'property' => 'typography',
                    'selector' => '.next-toast__toast-message',
                ],
            ],
            'default' => [
                'font-size' => '14px',
                'color' => [
                    'hex' => '#6b7280',
                ],
            ],
        ];

        //Close button style
        $this->controls['toastsCloseButtonStyleSeparator'] = [
            'label'      => esc_html__( 'Close Button Style', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['toastsCloseButtonPadding'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Padding', 'bricks' ),
            'type'    => 'spacing',
            'css'     => [
                [
                    'property' => 'padding',
                    'selector' => '.next-toast__toast-close',
                ],
            ],
            'default' => [
                'top'    => 4,
                'right'  => 4, 
                'bottom' => 4,
                'left'   => 4,
            ],
        ];
        $this->controls['toastsCloseButtonDimensions'] = [
            'tab' => 'content',
            'label' => esc_html__('Dimensions', 'bricks'),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => '--dimensions',
                    'selector' => '.next-toast__toast-close',
                ],
            ],
            'default' => '24px',
        ];
        $this->controls['toastsCloseButtonColor'] = [
            'tab' => 'content',
            'label' => esc_html__('Stroke Color', 'bricks'),
            'type' => 'color',
            'css' => [
                [
                    'property' => 'stroke',
                    'selector' => '.next-toast__toast-close > svg',
                ],
            ],
            'default' => [
                'hex' => '#6b7280',
            ],
        ];
        $this->controls['toastsCloseButtonStrokeWidth'] = [
            'tab' => 'content',
            'label' => esc_html__('Stroke Width', 'bricks'),
            'type' => 'number',
            'units' => true,
            'css' => [
                [
                    'property' => 'stroke-width',
                    'selector' => '.next-toast__toast-close > svg',
                ],
            ],
            'default' => '2',
        ];
        $this->controls['toastsCloseButtonBorder'] = [
            'tab' => 'content',
            'label' => esc_html__('Border', 'bricks'),
            'type' => 'border',
            'css' => [
                [
                    'property' => 'border',
                    'selector' => '.next-toast__toast-close',
                ],
            ],
            'default' => [
                'radius' => [
                  'top' => 8,
                  'right' => 8,
                  'bottom' => 8,
                  'left' => 8,
                ],
            ],
        ];
        $this->controls['toastsCloseButtonBackground'] = [
            'tab' => 'content',
            'label' => esc_html__('Background on hover', 'bricks'),
            'type' => 'background',
            'css' => [
                [
                    'property' => 'background',
                    'selector' => '.next-toast__toast-close:hover',
                ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#f3f4f6',
                ],
            ],
        ];

        //Show toasts
        $this->controls['showToastsSeparator'] = [
            'label'      => esc_html__( 'Show Toasts Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['showToastsDuration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type' => 'number',
            'unit' => 's',
            'inline' => true,
            'default' => '0.3s',
        ];
        $this->controls['showToastsEase'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'GSAP easing', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'none' => 'none',
                'power1' => 'power1',
                'power2' => 'power2',
                'power3' => 'power3',
                'power4' => 'power4',
                'back' => 'back',
                'bounce' => 'bounce',
                'circ' => 'circ',
                'elastic' => 'elastic',
                'expo' => 'expo',
                'sine' => 'sine',
                'steps' => 'steps'
            ],
            'inline' => true,
            'default' => 'back',
        ];

        //Hide toasts
        $this->controls['hideToastsSeparator'] = [
            'label'      => esc_html__( 'Hide Toasts Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['hideToastsDuration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type' => 'number',
            'unit' => 's',
            'inline' => true,
            'default' => '0.5s',
        ];
        $this->controls['hideToastsEase'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'GSAP easing', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'none' => 'none',
                'power1' => 'power1',
                'power2' => 'power2',
                'power3' => 'power3',
                'power4' => 'power4',
                'back' => 'back',
                'bounce' => 'bounce',
                'circ' => 'circ',
                'elastic' => 'elastic',
                'expo' => 'expo',
                'sine' => 'sine',
                'steps' => 'steps'
            ],
            'inline' => true,
            'default' => 'expo',
        ];

        //Expand toasts
        $this->controls['expandToastsSeparator'] = [
            'label'      => esc_html__( 'Expand Toasts Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['expandToastsDuration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type' => 'number',
            'unit' => 's',
            'inline' => true,
            'default' => '1s',
        ];
        $this->controls['expandToastsEase'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'GSAP easing', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'none' => 'none',
                'power1' => 'power1',
                'power2' => 'power2',
                'power3' => 'power3',
                'power4' => 'power4',
                'back' => 'back',
                'bounce' => 'bounce',
                'circ' => 'circ',
                'elastic' => 'elastic',
                'expo' => 'expo',
                'sine' => 'sine',
                'steps' => 'steps'
            ],
            'inline' => true,
            'default' => 'expo',
        ];

        //Collapse toasts
        $this->controls['collapseToastsSeparator'] = [
            'label'      => esc_html__( 'Collapse Toasts Animation', 'bricks' ),
            'type'       => 'separator',
        ];
        $this->controls['collapseToastsDuration'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'Duration', 'bricks' ),
            'type' => 'number',
            'unit' => 's',
            'inline' => true,
            'default' => '1s',
        ];
        $this->controls['collapseToastsEase'] = [
            'hasDynamicData' => false,
            'tab' => 'content',
            'label' => esc_html__( 'GSAP easing', 'bricks' ),
            'type' => 'select',
            'options'     => [
                'none' => 'none',
                'power1' => 'power1',
                'power2' => 'power2',
                'power3' => 'power3',
                'power4' => 'power4',
                'back' => 'back',
                'bounce' => 'bounce',
                'circ' => 'circ',
                'elastic' => 'elastic',
                'expo' => 'expo',
                'sine' => 'sine',
                'steps' => 'steps'
            ],
            'inline' => true,
            'default' => 'expo',
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_toast', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_toast.min.js', array('bricks-scripts'), NEXTBRICKS_VERSION, false);
    }

    public function render() {
        $settings = $this->settings;
        $showToastsDuration    = ! empty( $settings['showToastsDuration'] ) ? $settings['showToastsDuration'] : 0.3;
        $showToastsEase    = ! empty( $settings['showToastsEase'] ) ? $settings['showToastsEase'] : 'back';
        $hideToastsDuration    = ! empty( $settings['hideToastsDuration'] ) ? $settings['hideToastsDuration'] : 0.5;
        $hideToastsEase    = ! empty( $settings['hideToastsEase'] ) ? $settings['hideToastsEase'] : 'expo';
        $expandToastsDuration    = ! empty( $settings['expandToastsDuration'] ) ? $settings['expandToastsDuration'] : 1;
        $expandToastsEase    = ! empty( $settings['expandToastsEase'] ) ? $settings['expandToastsEase'] : 'expo';
        $collapseToastsDuration    = ! empty( $settings['collapseToastsDuration'] ) ? $settings['collapseToastsDuration'] : 1;
        $collapseToastsEase    = ! empty( $settings['collapseToastsEase'] ) ? $settings['collapseToastsEase'] : 'expo';

        $this->set_attribute('_root', 'class', "next-toast");
        $this->set_attribute('_root', 'data-show-duration', "$showToastsDuration");
        $this->set_attribute('_root', 'data-show-ease', "$showToastsEase");
        $this->set_attribute('_root', 'data-hide-duration', "$hideToastsDuration");
        $this->set_attribute('_root', 'data-hide-ease', "$hideToastsEase");
        $this->set_attribute('_root', 'data-expand-duration', "$expandToastsDuration");
        $this->set_attribute('_root', 'data-expand-ease', "$expandToastsEase");
        $this->set_attribute('_root', 'data-collapse-duration', "$collapseToastsDuration");
        $this->set_attribute('_root', 'data-collapse-ease', "$collapseToastsEase");

        $output = "<div {$this->render_attributes('_root')}>";

        // Render toasts if they exist
        if (!empty($settings['toasts'])) {
            foreach ($settings['toasts'] as $toast) {
                $output .= '<div class="next-toast__toast-data"';
                $output .= ' data-title="' . esc_attr($toast['title']) . '"';
                $output .= ' data-message="' . esc_attr($toast['message']) . '"';
                $output .= ' data-event="' . esc_attr($toast['event']) . '"';
                $output .= ' data-show-time="' . esc_attr($toast['showTime']) . '"';
                
                if (!empty($toast['trigger'])) {
                    $output .= ' data-trigger="' . esc_attr($toast['trigger']) . '"';
                }
                
                $output .= '></div>';
            }
        }

        $output .= "</div>";

        echo $output;
    }
}