<?php
namespace Bricks;
if ( ! defined( 'ABSPATH' ) ) exit;

class Next_Video_Tabs extends \Bricks\Element {
    public $category     = 'Next Bricks - Medias';
    public $name         = 'next_video_tabs';
    public $icon         = 'ti-video-clapper';
    public $tag          = 'div';
    public $scripts      = [ 'next_video_tabs' ];
    public $nestable     = true;

    public function get_label() {
        return esc_html__( 'Video Tabs', 'bricks' );
    }

    public function set_controls() {
        $this->controls['tag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'HTML tag', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'div'     => 'div',
                'section' => 'section',
                'article' => 'article',
                'main'    => 'main',
                'custom'  => 'custom',
            ],
            'clearable'   => false,
            'inline'      => true,
            'placeholder' => 'div',
            'default'     => 'div',
        ];

        $this->controls['customTag'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Custom tag', 'bricks' ),
            'type'        => 'text',
            'inline'      => true,
            'placeholder' => 'div',
            'required'    => [ 'tag', '=', 'custom' ],
        ];

        $this->controls['note'] = [
            'tab' => 'content',
            'description' => sprintf(html_entity_decode(esc_html__( 'Each element can be customized at its own Style tab or use the following controls.', 'bricks' )))
        ];

        $this->controls['videoTabsSeparator'] = [
            'label' => esc_html__( 'Video Tabs', 'bricks' ),
            'type'  => 'separator',
        ];
        $this->controls['direction'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Direction', 'bricks' ),
            'type'        => 'select',
            'options'     => [
                'row'    => esc_html__( 'Horizontal', 'bricks' ),
                'column' => esc_html__( 'Vertical', 'bricks' ),
            ],
            'inline'      => true,
            'default'     => 'row',
            'css'         => [
                [
                    'property' => 'flex-direction',
                    'selector' => '',
                ],
            ],
        ];
        $this->controls['gap'] = [
            'tab'         => 'content',
            'label'       => esc_html__( 'Gap', 'bricks' ),
            'type'        => 'number',
            'units'       => true,
            'default'     => '20px',
            'css'         => [
                [
                    'property' => 'gap',
                    'selector' => '',
                ],
            ],
        ];
        $this->controls['width'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Width', 'bricks' ),
            'type'    => 'number',
            'units'   => true,
            'default' => '100%',
            'css'     => [
                [
                    'property' => 'width',
                    'selector' => '',
                ],
            ],
        ];
        $this->controls['maxWidth'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Max width', 'bricks' ),
            'type'    => 'number',
            'units'   => true,
            'default' => '1200px',
            'css'     => [
                [
                    'property' => 'max-width',
                    'selector' => '',
                ],
            ],
        ];

        $this->controls['navItemsSeparator'] = [
            'label' => esc_html__( 'Nav Items', 'bricks' ),
            'type'  => 'separator',
        ];
        $this->controls['navItemsPadding'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Padding', 'bricks' ),
            'type'    => 'spacing',
            'default' => [
                'top'    => '10',
                'right'  => '20',
                'bottom' => '10',
                'left'   => '20',
                'unit'   => 'px',
            ],
            'css'     => [
                [
                    'property' => 'padding',
                    'selector' => '.nb-video-tabs__nav-item',
                ],
            ],
        ];
        $this->controls['navItemsGap'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Gap', 'bricks' ),
            'type'    => 'number',
            'units'   => true,
            'default' => '5px',
            'css'     => [
                [
                    'property' => 'gap',
                    'selector' => '.nb-video-tabs__nav-item',
                ],
            ],
        ];
        $this->controls['navItemsBorderRadius'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Border', 'bricks' ),
            'type'    => 'border',
            'default' => [
                'radius' => [
                    'top'    => '5',
                    'right'  => '5',
                    'bottom' => '5',
                    'left'   => '5',
                    'unit'   => 'px',
                ],
            ],
            'css'     => [
                [
                    'property' => 'border',
                    'selector' => '.nb-video-tabs__nav-item',
                ],
            ],
        ];
        $this->controls['navItemsBoxShadow'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Box Shadow', 'bricks' ),
            'type'    => 'box-shadow',
            'css'     => [
                [
                    'property' => 'box-shadow',
                    'selector' => '.nb-video-tabs__nav-item',
                ],
            ],
        ];
        $this->controls['navItemsBackground'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Background', 'bricks' ),
            'type'    => 'background',
            'css'   => [
                [
                    'property' => 'background',
                    'selector' => '.nb-video-tabs__nav-item',
                ],
            ],
        ];
        $this->controls['navItemsTypography'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Typography', 'bricks' ),
            'type'    => 'typography',
            'default' => [
                'font-size'   => '16px',
                'font-weight' => '500',
                'color'       => [
                    'hex' => '#000',
                ],
            ],
            'css'     => [
                [
                    'property' => 'typography',
                    'selector' => '.nb-video-tabs__nav-item',
                ],
            ],
        ];

        $this->controls['navItemsActiveSeparator'] = [
            'label' => esc_html__( 'Nav Items active', 'bricks' ),
            'type'  => 'separator',
        ];
        $this->controls['navItemsHoverBackground'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Hover Background', 'bricks' ),
            'type'    => 'background',
            'css'   => [
                [
                    'property' => 'background',
                    'selector' => '.nb-video-tabs__nav-item:hover',
                ],
                [
                    'property' => 'background',
                    'selector' => '.nb-video-tabs__nav-item:focus',
                ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#000',
                ],
            ],
        ];
        $this->controls['navItemsHoverColor'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Hover Color', 'bricks' ),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => 'color',
                    'selector' => '.nb-video-tabs__nav-item:hover',
                ],
                [
                    'property' => 'color',
                    'selector' => '.nb-video-tabs__nav-item:focus',
                ],
            ],
            'default' => [
                'hex' => '#fff',
            ],
        ];
        $this->controls['navItemsActiveBackground'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Active Background', 'bricks' ),
            'type'    => 'background',
            'css'   => [
                [
                    'property' => 'background',
                    'selector' => '.nb-video-tabs__nav-item[data-active="true"]',
                ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#000',
                ],
            ],
        ];
        $this->controls['navItemsActiveColor'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Active Color', 'bricks' ),
            'type'    => 'color',
            'css'     => [
                [
                    'property' => 'color',
                    'selector' => '.nb-video-tabs__nav-item[data-active="true"]',
                ],
            ],
            'default' => [
                'hex' => '#fff',
            ],
        ];
        $this->controls['navItemsTransitionDuration'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Duration', 'bricks' ),
            'type'    => 'text',
            'inline'  => true,
            'css'     => [
                [
                    'property' => '--nav-items-transition-duration',
                    'selector' => '',
                ],
            ],
            'default' => '0.3s',
        ];
        $this->controls['navItemsTransitionEasing'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'CSS Easing', 'bricks' ),
            'type'    => 'text',
            'css'     => [
                [
                    'property' => '--nav-items-transition-easing',
                    'selector' => '',
                ],
            ],
            'default' => 'ease',
        ];

        $this->controls['progressBarSeparator'] = [
            'label' => esc_html__( 'Progress Bar', 'bricks' ),
            'type'  => 'separator',
        ];
        $this->controls['progressBarWidth'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Width', 'bricks' ),
            'type'    => 'number',
            'units'   => true,
            'css'     => [
                [
                    'property' => 'width',
                    'selector' => '.nb-video-tabs__progress-bar',
                ],
            ],
            'default' => '100%'
        ];
        $this->controls['progressBarHeight'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Height', 'bricks' ),
            'type'    => 'number',
            'units'   => true,
            'css'     => [
                [
                    'property' => 'height',
                    'selector' => '.nb-video-tabs__progress-bar',
                ],
            ],
            'default' => '3px',
        ];
        $this->controls['progressBackground'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Progress Color', 'bricks' ),
            'type'    => 'background',
            'css'     => [
                [
                    'property' => 'background',
                    'selector' => '.nb-video-tabs__progress',
                ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#fff',
                ],
            ],
        ];
        $this->controls['progressBarBackground'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Path Background', 'bricks' ),
            'type'    => 'background',
            'css'     => [
                [
                    'property' => 'background',
                    'selector' => '.nb-video-tabs__progress-bar',
                ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#ccc',
                ],
            ],
        ];
        $this->controls['progressBarBorder'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Border', 'bricks' ),
            'type'    => 'border',
            'css'     => [
                [
                    'property' => 'border',
                    'selector' => '.nb-video-tabs__progress-bar',
                ],
            ],
            'default' => [
                'radius' => [
                    'top'    => '100px',
                    'right'  => '100px',
                    'bottom' => '100px',
                    'left'   => '100px',
                ],
            ],
        ];
        $this->controls['progressBarBoxShadow'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Box Shadow', 'bricks' ),
            'type'    => 'box-shadow',
            'css'     => [
                [
                    'property' => 'box-shadow',
                    'selector' => '.nb-video-tabs__progress-bar',
                ],
            ],
        ];

        $this->controls['progressAnimationsSeparator'] = [
            'label' => esc_html__( 'Progress', 'bricks' ),
            'type'  => 'separator',
        ];
        $this->controls['progressTransitionDuration'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Duration', 'bricks' ),
            'type'    => 'text',
            'inline' => true,
            'css'     => [
                [
                    'property' => '--progress-transition-duration',
                    'selector' => '',
                ],
            ],
            'default' => '0.1s',
        ];
        $this->controls['progressTransitionEasing'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'CSS Easing', 'bricks' ),
            'type'    => 'text',
            'css'     => [
                [
                    'property' => '--progress-transition-easing',
                    'selector' => '',
                ],
            ],
            'default' => 'linear',
        ];

        $this->controls['progressBarAnimationsSeparator'] = [
            'label' => esc_html__( 'Path Animations', 'bricks' ),
            'type'  => 'separator',
        ];
        $this->controls['progressBarHoverBackground'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Hover Background', 'bricks' ),
            'type'    => 'background',
            'css'     => [
                [
                    'property' => 'background',
                    'selector' => '.nb-video-tabs__nav-item:hover .nb-video-tabs__progress-bar',
                ],
                [
                    'property' => 'background',
                    'selector' => '.nb-video-tabs__nav-item:focus .nb-video-tabs__progress-bar',
                ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#555',
                ],
            ],
        ];
        $this->controls['progressBarActiveBackground'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Active Background', 'bricks' ),
            'type'    => 'background',
            'css'     => [
                [
                    'property' => 'background',
                    'selector' => '.nb-video-tabs__nav-item[data-active="true"] .nb-video-tabs__progress-bar',
                ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#555',
                ],
            ],
        ];
        $this->controls['progressBarTransitionDuration'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Duration', 'bricks' ),
            'type'    => 'text',
            'inline' => true,
            'css'     => [
                [
                    'property' => '--progress-bar-transition-duration',
                    'selector' => '',
                ],
            ],
            'default' => '0.3s',
        ];
        $this->controls['progressBarTransitionEasing'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'CSS Easing', 'bricks' ),
            'type'    => 'text',
            'css'     => [
                [
                    'property' => '--progress-bar-transition-easing',
                    'selector' => '',
                ],
            ],
            'default' => 'ease',
        ];

        $this->controls['videosWrapperSeparator'] = [
            'label' => esc_html__( 'Videos Wrapper', 'bricks' ),
            'type'  => 'separator',
        ];
        $this->controls['videosWrapperBackground'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Background', 'bricks' ),
            'type'    => 'background',
            'css'     => [
                [
                    'property' => 'background-color',
                    'selector' => '.nb-video-tabs__videos',
                ],
            ],
            'default' => [
                'color' => [
                    'hex' => '#000',
                ],
            ],
        ];
        $this->controls['videosWrapperBorder'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Border', 'bricks' ),
            'type'    => 'border',
            'css'     => [
                [
                    'property' => 'border',
                    'selector' => '.nb-video-tabs__videos',
                ],
            ],
            'default' => [
                'radius' => [
                    'top'    => '16px',
                    'right'  => '16px',
                    'bottom' => '16px',
                    'left'   => '16px',
                ],
            ],
        ];
        $this->controls['videosWrapperBoxShadow'] = [
            'tab'     => 'content',
            'label'   => esc_html__( 'Box Shadow', 'bricks' ),
            'type'    => 'box-shadow',
            'css'     => [
                [
                    'property' => 'box-shadow',
                    'selector' => '.nb-video-tabs__videos',
                ],
            ],
        ];
    }

    public function get_nestable_children() {
        return [
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Nav', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'nb-video-tabs__nav',
                    ],
                    '_direction' => 'column',
                    '_gap' => [
                        'size' => '20',
                        'unit' => 'px',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Nav Item', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'nb-video-tabs__nav-item',
                            ],
                            '_attributes' => [
                                [
                                    'name'  => 'tabindex',
                                    'value' => '0',
                                ],
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'heading',
                                'label'    => esc_html__( 'Heading', 'bricks' ),
                                'settings' => [
                                    'text' => esc_html__( 'Video 1', 'bricks' ),
                                    'tag'  => 'span',
                                ],
                            ],
                            [
                                'name'     => 'block',
                                'label'    => esc_html__( 'Progress Bar', 'bricks' ),
                                'settings' => [
                                    '_hidden'  => [
                                        '_cssClasses' => 'nb-video-tabs__progress-bar',
                                    ],
                                ],
                            ]
                        ],
                    ],
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Nav Item', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'nb-video-tabs__nav-item',
                            ],
                            '_attributes' => [
                                [
                                    'name'  => 'tabindex',
                                    'value' => '0',
                                ],
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'heading',
                                'label'    => esc_html__( 'Heading', 'bricks' ),
                                'settings' => [
                                    'text' => esc_html__( 'Video 2', 'bricks' ),
                                    'tag'  => 'span',
                                ],
                            ],
                            [
                                'name'     => 'block',
                                'label'    => esc_html__( 'Progress Bar', 'bricks' ),
                                'settings' => [
                                    '_hidden'  => [
                                        '_cssClasses' => 'nb-video-tabs__progress-bar',
                                    ],
                                ],
                            ]
                        ],
                    ],
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Nav Item', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'nb-video-tabs__nav-item',
                            ],
                            '_attributes' => [
                                [
                                    'name'  => 'tabindex',
                                    'value' => '0',
                                ],
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'heading',
                                'label'    => esc_html__( 'Heading', 'bricks' ),
                                'settings' => [
                                    'text' => esc_html__( 'Video 3', 'bricks' ),
                                    'tag'  => 'span',
                                ],
                            ],
                            [
                                'name'     => 'block',
                                'label'    => esc_html__( 'Progress Bar', 'bricks' ),
                                'settings' => [
                                    '_hidden'  => [
                                        '_cssClasses' => 'nb-video-tabs__progress-bar',
                                    ],
                                ],
                            ]
                        ],
                    ],
                ],
            ],
            [
                'name'     => 'block',
                'label'    => esc_html__( 'Videos', 'bricks' ),
                'settings' => [
                    '_hidden'  => [
                        '_cssClasses' => 'nb-video-tabs__videos',
                    ],
                ],
                'children' => [
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Video Item', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'nb-video-tabs__video-item',
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'video',
                                'label'    => esc_html__( 'Video', 'bricks' ),
                                'settings' => [
                                    'videoType'   => 'file',
                                    'fileUrl'     => 'https://figpress.io/wp-content/uploads/2024/09/Prepare-your-design.mp4',
                                    'fileMute'    => true,
                                    'fileLoop'    => true,
                                    'fileInline'  => true,
                                    'fileAutoplay'=> true,
                                ],
                            ],
                        ],
                    ],
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Video Item', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'nb-video-tabs__video-item',
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'video',
                                'label'    => esc_html__( 'Video', 'bricks' ),
                                'settings' => [
                                    'videoType'   => 'file',
                                    'fileUrl'     => 'https://figpress.io/wp-content/uploads/2024/09/Copy-your-design.mp4',
                                    'fileMute'    => true,
                                    'fileLoop'    => true,
                                    'fileInline'  => true,
                                    'fileAutoplay'=> true,
                                ],
                            ],
                        ],
                    ],
                    [
                        'name'     => 'block',
                        'label'    => esc_html__( 'Video Item', 'bricks' ),
                        'settings' => [
                            '_hidden'  => [
                                '_cssClasses' => 'nb-video-tabs__video-item',
                            ],
                        ],
                        'children' => [
                            [
                                'name'     => 'video',
                                'label'    => esc_html__( 'Video', 'bricks' ),
                                'settings' => [
                                    'videoType'   => 'file',
                                    'fileUrl'     => 'https://figpress.io/wp-content/uploads/2024/09/Paste-your-design.mp4',
                                    'fileMute'    => true,
                                    'fileLoop'    => true,
                                    'fileInline'  => true,
                                    'fileAutoplay'=> true,
                                ],
                            ],
                        ],
                    ],
                ],
            ],
        ];
    }

    public function enqueue_scripts() {
        wp_enqueue_script( 'next_video_tabs', NEXTBRICKS_PLUGIN_URL . 'elements/js/next_video_tabs.min.js', array( 'bricks-scripts' ), NEXTBRICKS_VERSION, false );
    }

    public function render() {
        $this->set_attribute( '_root', 'class', 'nb-video-tabs' );

        if ( ! bricks_is_builder() ) {
            $this->set_attribute( '_root', 'data-flickering', 'true' );
        }

        $output  = "<{$this->tag} {$this->render_attributes( '_root' )}>";
        $output .= Frontend::render_children( $this );
        $output .= "</{$this->tag}>";

        echo $output;
    }
}
