<?php

/**
 * Plugin Name: Next Bricks
 * Plugin URI: https://nextbricks.io/
 * Description: Beautiful elements and features designed for Bricks Builder.
 * Version:  2.2.2
 * Requires PHP: 7.4
 * Requires at least: 4.7
 * Author: Jose Tamu
 * Author URI: https://www.josetamu.com/
*/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// Update brickscore_license_options with mock values
update_option('brickscore_license_options', array(
    'sc_license_key' => '12345678-90ab-cdef-1234-567890abcdef',
    'sc_license_id' => 'abcdef12-3456-7890-abcd-ef1234567890',
    'sc_activation_id' => '09876543-21fe-dcba-0987-654321fedcba'
));
update_option('activate_brickscore', '1');

add_filter('pre_http_request', function($preempt, $r, $url) {
    // Check if the request is targeting the specific URL
    if (strpos($url, 'https://api.surecart.com/v1/public/activations/') !== false) {
        // Get the current website URL
        $current_url = home_url();
        
        // Get the current timestamp
        $current_time = time();
        
        // Provide a custom response
        return array(
            'headers'  => array(),
            'body'     => json_encode(array(
                'id' => '09876543-21fe-dcba-0987-654321fedcba',
                'object' => 'activation',
                'counted' => false,
                'name' => 'GPL',
                'fingerprint' => $current_url,
                'license' => 'abcdef12-3456-7890-abcd-ef1234567890',
                'created_at' => $current_time,
                'updated_at' => $current_time,
            )),
            'response' => array(
                'code'    => 200,
                'message' => 'OK',
            ),
        );
    }

    // If the URL doesn't match, return false to let the request proceed as normal
    return $preempt;
}, 10, 3);

define('NEXTBRICKS_VERSION', '2.2.2');
define('LATEST_BRICKS_VERSION', '2.1.2');
define('NEXTBRICKS_FILE', __FILE__);
define('NEXTBRICKS_FILE_NAME', plugin_basename(__FILE__));
define('NEXTBRICKS_PLUGIN_URL', plugin_dir_url(__FILE__));
define('NEXTBRICKS_PLUGIN_DIR', plugin_dir_path(__FILE__));

require_once NEXTBRICKS_PLUGIN_DIR . 'initialize.php';
new NextBricks\Initialize();