(function($){
	'use strict';

	$(document).ready(function()
	{
        // Init NSG Meta Box tabs
        $( "#nsg-tabs" ).tabs();

        // Mark URL structure part when matching input field gets focus
        jQuery('#nsg-seo-page-base, #nsg-slug-placeholder').on('focus blur', function (e) {
            var for_label = $(this).attr('id');
            if(e.type === 'focus')
            {
                $('.nsg-url-structure label[for="' + for_label + '"').css('background-color', 'yellow');
            }
            else
            {
                $('.nsg-url-structure label[for="' + for_label + '"').css('background-color', '');
            }
        });

        // Live update the URL Structure when SEO Page Base and Slug placeholder are being updated to reflect new URL Structure
        jQuery('#nsg-seo-page-base, #nsg-slug-placeholder').on('input propertychange paste',function() {
            var for_label   = $(this).attr('id');
            var value       = $(this).val();
            if (value !== '' && for_label === 'nsg-seo-page-base')
            {
                value = "/" + value;
            }
            $('.nsg-url-structure label[for="' + for_label + '"').html(value);
        });

        // Add counter to the Search Term textarea to count number of lines
        jQuery(".nsg-search-terms .nsg-content").each(function() {
            var textarea_wrapper = jQuery(this);
            nsg_update_textarea_lines(textarea_wrapper, 'nsg-search-terms');
        });

        jQuery(".nsg-search-terms .nsg-content textarea").on('input propertychange paste', function() {
            var textarea_wrapper = jQuery(this).closest(".nsg-content");
            nsg_update_textarea_lines(textarea_wrapper, 'nsg-search-terms');
        });

        // Add counter to the Location textarea to count number of lines
		jQuery(".nsg-locations .nsg-content").each(function() {
            var textarea_wrapper = jQuery(this);
            nsg_update_textarea_lines(textarea_wrapper, 'nsg-locations');
        });

        jQuery(".nsg-locations .nsg-content textarea").on('input propertychange paste', function() {
            var textarea_wrapper = jQuery(this).closest(".nsg-content");
            nsg_update_textarea_lines(textarea_wrapper, 'nsg-locations');
        });

        // Update numb lines counter below textarea and mark if max lines has been exceeded
        function nsg_update_textarea_lines(textarea_wrapper, field_type)
        {
            var my_textarea     = textarea_wrapper.find("textarea");
            var text            = my_textarea.val();
            var lines           = text.split(/\r|\r\n|\n/);
            lines               = lines.filter(function(v){return v!==''}); // remove empty lines
            var count           = lines.length;
            var max_items       = field_type === 'nsg-search-terms' ? nsg.max_search_terms : nsg.max_locations;

            if (count > max_items)
            {
                textarea_wrapper.find('.num_lines').addClass('error');
            }
            else
            {
                textarea_wrapper.find('.num_lines').removeClass('error');
            }

            if (textarea_wrapper.find('.num_lines').length < 1)
            {
                $("<p class='num_lines'>" + nsg.lines + count + " (" + nsg.max + " " + max_items + ")</p>").insertAfter(textarea_wrapper.find('textarea'));
            }
            else
            {
                textarea_wrapper.find('.num_lines').html(nsg.lines + count + " (" + nsg.max + max_items + ")");
            }
        }

        // Add toggle on Settings options page
        if ($('.nsg-settings-meta-box-wrap').length > 0)
        {
            $('.if-js-closed').removeClass('if-js-closed').addClass('closed');
            postboxes.add_postbox_toggles( 'nw_seo_page_page_nsg-settings' );

            // display spinner
            $('#nsg-form').submit( function()
            {
                $('#publishing-action .spinner').css('visibility','initial');
            });
        }

        // On Edit SEO Page:
        function nsg_edit_seo_page_toggle_fields()
        {
            const archive_enabled = nsg_toggle_enable_archive_page();
            nsg_toggle_redirect_ul(archive_enabled);
            nsg_toggle_enable_custom_archive_page(archive_enabled);
        }

        if ($('input[name="nsg-enable_archive_page"]').length > 0)
        {
            $('input[name="nsg-enable_archive_page"]').on('change', nsg_edit_seo_page_toggle_fields);
        }
        function nsg_toggle_enable_archive_page()
        {
            const archive_enabled = $('input[name="nsg-enable_archive_page"]:checked').val();

            if (archive_enabled === '1')
            {
                $('.css-id-nsg-archive_page_disabled_behavior, .css-id-nsg-archive_page_redirect_url').hide();
                $('.css-id-nsg-enable_custom_archive_page, .css-id-nsg-archive_page_custom_page_id, .css-id-nsg-enable_noindex_archive_page').show();
            }
            else
            {
                $('.css-id-nsg-archive_page_disabled_behavior, .css-id-nsg-archive_page_redirect_url').show();
                $('.css-id-nsg-enable_custom_archive_page, .css-id-nsg-archive_page_custom_page_id, .css-id-nsg-enable_noindex_archive_page').hide();
            }

            return archive_enabled;
        }

        if ($('#nsg-archive_page_disabled_behavior').length > 0)
        {
            $('#nsg-archive_page_disabled_behavior').on('change', nsg_edit_seo_page_toggle_fields);
        }
        function nsg_toggle_redirect_ul(archive_enabled)
        {
            const value = $('#nsg-archive_page_disabled_behavior').val();

            if (value === '404' || archive_enabled === '1')
            {
                $('.css-id-nsg-archive_page_redirect_url').hide();
            }
            else
            {
                $('.css-id-nsg-archive_page_redirect_url').show();
            }
        }

        if ($('input[name="nsg-enable_custom_archive_page"]').length > 0)
        {
            $('input[name="nsg-enable_custom_archive_page"]').on('change', nsg_edit_seo_page_toggle_fields);
        }
        
        function nsg_toggle_enable_custom_archive_page(archive_enabled)
        {
            const custom_archive_page_enabled = $('input[name="nsg-enable_custom_archive_page"]:checked').val();

            if (archive_enabled === '1')
            {
                if (custom_archive_page_enabled === '1')
                {
                    $('.css-id-nsg-archive_page_custom_page_id').show();

                    // Hide noindex as a custom external page is selected for the archive page. That page can decide to enable or disable indexing
                    $('.css-id-nsg-enable_noindex_archive_page').hide();
                }
                else
                {
                    $('.css-id-nsg-enable_noindex_archive_page').show();
                    $('.css-id-nsg-archive_page_custom_page_id').hide();
                }
                
            }
            else
            {
                $('.css-id-nsg-archive_page_custom_page_id').hide();
            }

            return custom_archive_page_enabled;
        }

        // Run on page load
        if ($('input[name="nsg-enable_archive_page"]').length > 0)
        {
            nsg_edit_seo_page_toggle_fields();
        }
        
        // SEO Generator Settings Page
        if ($('input[name="nsg-enable_custom_excerpt_tag"]').length > 0)
        {
            // On Load
            nsg_edit_seo_generator_settings_toggle_excerpt_length_field();

            // On Change
            jQuery('input[name="nsg-enable_custom_excerpt_tag"]').on('change', nsg_edit_seo_generator_settings_toggle_excerpt_length_field);
        }
        function nsg_edit_seo_generator_settings_toggle_excerpt_length_field()
        {
            var enabled = $('input[name="nsg-enable_custom_excerpt_tag"]:checked').val();

            if (enabled === '1')
            {
                jQuery('.css-id-nsg-custom_excerpt_length').show();
            }
            else
            {
                jQuery('.css-id-nsg-custom_excerpt_length').hide();
            }
        }

        // SEO Generator Settings Page
        if ($('input[name="nsg-enable_spintax"]').length > 0)
        {
            // On Load
            nsg_edit_seo_generator_settings_toggle_fields();

            // On Change
            jQuery('input[name="nsg-enable_spintax"]').on('change', nsg_edit_seo_generator_settings_toggle_fields);
        }
        function nsg_edit_seo_generator_settings_toggle_fields()
        {
            if (jQuery('input[name="nsg-enable_spintax"]').length > 0)
            {
                const enabled = $('input[name="nsg-enable_spintax"]:checked').val();

                if (enabled === '1')
                {
                    jQuery('.css-id-nsg-randomize_spintax').show();
                }
                else
                {
                    jQuery('.css-id-nsg-randomize_spintax').hide();
                }
            }
        }
        
    });

})(jQuery);
