// NSG Table of Contents JavaScript - Plain JS

document.addEventListener('DOMContentLoaded', function() {
    
    // Handle TOC toggle functionality
    const toggleButtons = document.querySelectorAll('.nsg-toc-toggle');
    toggleButtons.forEach(function(button) {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            
            const tocContainer = button.closest('.nsg-table-of-contents');
            const content = tocContainer.querySelector('.nsg-toc-content');
            const toggleText = button.querySelector('.nsg-toc-toggle-text');
            
            if (content.classList.contains('nsg-toc-hidden')) {
                content.classList.remove('nsg-toc-hidden');
                toggleText.textContent = '[hide]';
            } else {
                content.classList.add('nsg-toc-hidden');
                toggleText.textContent = '[show]';
            }
        });
    });
    
    // Smooth scrolling for TOC links
    const tocLinks = document.querySelectorAll('.nsg-toc-list a');
    tocLinks.forEach(function(link) {
        link.addEventListener('click', function(e) {
            const href = link.getAttribute('href');
            
            if (href.indexOf('#') === 0) {
                e.preventDefault();
                
                const target = document.querySelector(href);
                if (target) {
                    const offsetTop = target.getBoundingClientRect().top + window.pageYOffset - 80; // Account for fixed headers
                    
                    window.scrollTo({
                        top: offsetTop,
                        behavior: 'smooth'
                    });
                }
            }
        });
    });
    
    // Highlight current section in TOC (optional enhancement)
    const tocList = document.querySelector('.nsg-toc-list');
    if (tocList) {
        const tocLinksArray = Array.from(tocLinks);
        const sections = [];
        
        // Collect all target sections
        tocLinksArray.forEach(function(link) {
            const href = link.getAttribute('href');
            if (href.indexOf('#') === 0) {
                const section = document.querySelector(href);
                if (section) {
                    sections.push(section);
                }
            }
        });
        
        // Highlight current section on scroll
        function updateActiveSection() {
            const scrollPos = window.pageYOffset + 100;
            
            sections.forEach(function(section) {
                const sectionTop = section.getBoundingClientRect().top + window.pageYOffset;
                const sectionBottom = sectionTop + section.offsetHeight;
                
                if (scrollPos >= sectionTop && scrollPos < sectionBottom) {
                    const id = section.getAttribute('id');
                    
                    // Remove active class from all links
                    tocLinksArray.forEach(function(link) {
                        link.classList.remove('nsg-toc-active');
                    });
                    
                    // Add active class to current link
                    const activeLink = tocList.querySelector('a[href="#' + id + '"]');
                    if (activeLink) {
                        activeLink.classList.add('nsg-toc-active');
                    }
                }
            });
        }
        
        window.addEventListener('scroll', updateActiveSection);
    }
});