<?php

if (!is_admin())
{
    // Filter All in One SEO title and meta description
    add_filter('aioseo_title', 'nsg_get_seo_pages_replace_search_terms_and_locations', 10, 1);
    add_filter('aioseo_description', 'nsg_get_seo_pages_replace_search_terms_and_locations', 10, 1);
    add_filter('aioseo_schema_output', 'nsg_replace_search_terms_and_locations_for_aioseo_schema_graph', 10, 1);
}

function nsg_replace_search_terms_and_locations_for_aioseo_schema_graph($schema_output)
{
    // Recursive function to handle nested arrays
    function replace_search_term_placeholders(&$item)
    {
        if (is_array($item))
        {
            // Iterate through nested arrays
            foreach ($item as &$value)
            {
                replace_search_term_placeholders($value);
            }
        }
        elseif (is_string($item))
        {
            // Replace [location] & [search_term] placeholders in string values
            $item = nsg_get_seo_pages_replace_search_terms_and_locations($item);
        }
    }

    // Apply the replacement to the entire schema output
    replace_search_term_placeholders($schema_output);

    return $schema_output;
}

