<?php

/**
 * Adds a fake metabox on CPT nw_seo_page edit pages
 * 
 * Adds fields to define URL structure of dynamically generated SEO Pages
 * 
 * Only loadded on Post Edit screen of CPT = nw_seo_page
 */
class NSG_Config extends NSG_Tabs
{
	/**
	 * Fake meta box configuration
	 * 
	 * @var array
	 */
	private $meta_box_config;

	/**
	 * 
	 */
	public function __construct()
	{
		// Fake meta box configuration
		$this->meta_box_config = array(
			'id'		=> 'nsg-seo-page-config',
			'title'		=> __('SEO Page settings', 'nsg_seo_generator'),
		);

		$this->nonce_name 				= $this->meta_box_config['id'] . '_nonce';
        
        $this->add_tabs_and_fields();
    }

    private function add_tabs_and_fields()
    {
        $nsg							= NSG_Seo_Generator::get_instance();
		$search_term_placeholder		= $nsg->get_search_term_single_placeholder();
		$search_term_plural_placeholder	= $nsg->get_search_term_plural_placeholder();

		$location_placeholder 			= $nsg->get_location_single_placeholder();
		// $location_plural_placeholder 	= $nsg->get_location_plural_placeholder();

		// Create NSG_Meta_field fields
		$seo_page_base_field = new NSG_Meta_Input_Field(
			array(
                'attr'          => array(
                    'type'          => 'text',
                    'id' 			=> 'seo-page-base',
                    'placeholder'	=> __("SEO Page base", 'nsg_seo_generator'),
                    'autocomplete'	=> 'off'
                ),
				'label' 		=> __('SEO Page base', 'nsg_seo_generator'),
				'wrapper_class'	=> array('nsg-small-12', 'nsg-medium-3', 'nsg-seo-page-base'),
				'desc'			=> __("The SEO Page base will be used in all generated SEO Page URLs. This would make your URLs look like the URL Structure below.", 'nsg_seo_generator'),
			)
		);

		$slug_placeholder_field = new NSG_Meta_Input_Field(
			array(
                'attr'          => array(
                    'type'          => 'text',
                    'id' 			=> 'slug-placeholder',
                    'placeholder'	=> "{$search_term_placeholder}-in-{$location_placeholder}",
					'autocomplete'	=> 'off',
                ),
				'label' 		=> __('Slug', 'nsg_seo_generator'),
				'wrapper_class'	=> array('nsg-small-12', 'nsg-medium-3', 'nsg-slug-placeholder'),
				'default'		=> "{$search_term_placeholder}-in-{$location_placeholder}",
				'desc'			=> sprintf(
									__("Enter the slug with %s and %s to generate unique URLs for each combination of a search term and a location.", 'nsg_seo_generator'),
									$search_term_placeholder,
									$location_placeholder
								)
			)
		);

		$archive_page_title_field = new NSG_Meta_Input_Field(
			array(
                'attr'          => array(
                    'type'          => 'text',
                    'id' 			=> 'archive-page-title',
                    'placeholder'	=> __('Archive', 'nsg_seo_generator'),
					'autocomplete'	=> 'off',
                ),
				'label' 		=> __('Archive page title', 'nsg_seo_generator'),
				'wrapper_class'	=> array('nsg-small-12', 'nsg-medium-3', 'nsg-slug-placeholder'),
				'default'		=> __('Archive', 'nsg_seo_generator'),
				'desc'			=> __("Enter the page title to show on the archive page.", 'nsg_seo_generator'),
			)
		);

        $overview_label_field = new NSG_Meta_Input_Field(
			array(
                'attr'          => array(
                    'type'          => 'text',
                    'id' 			=> 'overview-label',
                    'placeholder'	=> __('Overview', 'nsg_seo_generator'),
					'autocomplete'	=> 'off',
                ),
				'label' 		=> __('Overview label', 'nsg_seo_generator'),
				'wrapper_class'	=> array('nsg-small-12', 'nsg-medium-3', 'nsg-slug-placeholder'),
				'default'		=> '',
				'desc'			=> __("Enter the label to use for the link to archive page.", 'nsg_seo_generator'),
			)
		);
		
		$url_example_field = new NSG_Meta_HTML_Field(
			array(
                'attr'          => array(
                    'id'    => 'url-structure',
                    'type'  => 'html'
                ),
				'label'         => __('URL Structure', 'nsg_seo_generator'),
				'wrapper_class' => array('nsg-small-12')
			)
		);

		$nsg_get_search_terms_field = new NSG_Meta_Textarea_Field(
			array(
                'attr'          => array(
                    'id' 			=> 'search-terms',
                    'placeholder'	=> __('One search term per line. Separate single and plural values with the pipe | character', 'nsg_seo_generator'),
                    'type'          => 'textarea',
                    'rows'          => 5
                ),
				'label' 		=> __('Search terms', 'nsg_seo_generator'),
				'wrapper_class'	=> array('nsg-small-12', 'nsg-medium-6', 'nsg-search-terms', 'nsg-textarea-max-length'),
				'desc'			=> sprintf(
									__("Enter a list of unique search terms. For every SEO Page each %s and %s placeholder will be replaced by a search term from this list. Separate two search terms on a single line by the pipe | character for single and plural values", 'nsg_seo_generator'),
									$search_term_placeholder,
									$search_term_plural_placeholder
								)
			)
		);

		$nsg_locations_field = new NSG_Meta_Textarea_Field(
			array(
                'attr'          => array(
                    'id' 			=> 'locations',
                    'placeholder'	=> __('One location per line.  Separate single and plural values with the pipe | character', 'nsg_seo_generator'),
                    'type'          => 'textarea',
                    'rows'          => 5
                ),
				'label' 		=> __('Locations', 'nsg_seo_generator'),
				'wrapper_class'	=> array('nsg-small-12', 'nsg-medium-6', 'nsg-locations', 'nsg-textarea-max-length'),
				'desc'			=> sprintf(
									__("Enter a list of unique locations. For every SEO Page each %s placeholder will be replaced by a location from this list.", 'nsg_seo_generator'),
									$location_placeholder
								)
			)
		);

		$html_field = new NSG_Meta_HTML_Field(
			array(
                'attr'          => array(
                    'id'    => 'explanation',
                    'type'  => 'html'
                ),				
				'label'         => __('Overview generated URLs', 'nsg_seo_generator'),
				'wrapper_class' => array('nsg-small-12')
			)
		);

        $title_tag_field = new NSG_Meta_Input_Field(
			array(
                'attr'          => array(
                    'type'          => 'text',
                    'id' 			=> 'title-tag',
                    'placeholder'	=> __('SEO title', 'nsg_seo_generator'),
					'autocomplete'	=> 'off',
                ),
				'label' 		=> __('SEO title', 'nsg_seo_generator'),
				'wrapper_class'	=> array('nsg-small-12', 'nsg-medium-6', 'nsg-title-tag'),
				'default'		=> '',
				'desc'			=> __("Enter the title tag for the head. Leave empty to use the default Wordpress title-tag or of your SEO plugin, if it supports SEO Generator.", 'nsg_seo_generator'),
			)
		);

        $meta_description_field = new NSG_Meta_Textarea_Field(
			array(
                'attr'          => array(
                    'id' 			=> 'meta-description',
                    'placeholder'	=> __('Meta description', 'nsg_meta_description'),
                    'type'          => 'textarea',
                    'rows'          => 3
                ),
				'label' 		=> __('Meta description', 'nsg_seo_generator'),
				'wrapper_class'	=> array('nsg-small-12', 'nsg-medium-6', 'nsg_meta_description'),
				'desc'			=> sprintf(
									__("Enter the meta description with %s and %s to generate a unique meta description for each page. Leave empty to use the Meta description of your SEO plugin, if it supports SEO Generator.", 'nsg_seo_generator'),
									$search_term_placeholder,
									$location_placeholder
								)
			)
		);

        #####################################################################
        ###                      ARCHIVE PAGE SETTINGS
        #####################################################################

        $enable_archive_page = new NSG_Meta_Radiobutton_Group_Field(
            array(
                'attr'          => array(
                    'type'      => 'radio',
                    'id'        => "enable_archive_page",
                ),
                'label'         => __('Enable Archive Page', 'nsg_seo_generator'),
                'wrapper_class' => array('nsg-col', 'nsg-small-12', 'nsg-styled-radios'),
                'radios'       => array(
                    0 => __('No', 'nsg_seo_generator'),
                    1 => __('Yes', 'nsg_seo_generator'),
                ),
                'default'       => 1,
                'is_option'     => false,
                'desc' => __("Enable the Archive page that lists all generated URLs vor this SEO Generator page. The settings below determine what happens if someone tries to access it.", 'nsg_seo_generator')
            )
        );

        $archive_page_behavior = new NSG_Meta_Select_Field(
            array(
                'attr'          => array(
                    'type'      => 'select',
                    'id'        => 'archive_page_disabled_behavior'
                ),
                'label'         => __('Disabled Archive Page Behavior', 'nsg_seo_generator'),
                'wrapper_class' => array('nsg-col', 'nsg-small-12', 'nsg-medium-6', 'nsg-styled-radios'),
                'options'       => array(
                    '404'      => __('Show 404 error', 'nsg_seo_generator'),
                    'redirect' => __('Redirect to a custom URL', 'nsg_seo_generator')
                ),
                'default'       => '404',
                'is_option'     => false,
                'desc'          => __('What should happen when the Archive page is disabled?', 'nsg_seo_generator')
            )
        );

        $archive_page_redirect_url = new NSG_Meta_Input_Field(
            array(
                'attr'          => array(
                    'type'        => 'text',
                    'id'          => 'archive_page_redirect_url',
                    'placeholder' => 'https://example.com'
                ),
                'label'         => __('Redirect URL', 'nsg_seo_generator'),
                'wrapper_class' => array('nsg-col', 'nsg-small-12', 'nsg-medium-6'),
                'default'       => '',
                'is_option'     => false,
                'desc'          => __('Used if redirect is selected above.', 'nsg_seo_generator')
            )
        );

        $enable_custom_archive_page = new NSG_Meta_Radiobutton_Group_Field(
            array(
                'attr'          => array(
                    'type'      => 'radio',
                    'id'        => "enable_custom_archive_page",
                ),
                'label'         => __('Enable Custom Archive Page', 'nsg_seo_generator'),
                'wrapper_class' => array('nsg-col', 'nsg-small-12', 'nsg-medium-6', 'nsg-styled-radios'),
                'radios'       => array(
                    0 => __('No', 'nsg_seo_generator'),
                    1 => __('Yes', 'nsg_seo_generator'),
                ),
                'default'       => 0,
                'is_option'     => false,
                'desc' => __("Enable to use a Custom Archive Page for more styling options", 'nsg_seo_generator')
            )
        );

        // Dropdown for selecting a WordPress page
        add_filter('nsg_select_field_options_nsg-archive_page_custom_page_id', 'nsg_populate_page_dropdown');

        $archive_page_custom_page_id = new NSG_Meta_Select_Field(
            array(
                'attr' => array(
                    'type'      => 'select',
                    'id'        => 'archive_page_custom_page_id'
                ),
                'label'         => __('Custom Archive Page', 'nsg_seo_generator'),
                'wrapper_class' => array('nsg-col', 'nsg-small-12', 'nsg-medium-6'),
                'default'       => '',
                'is_option'     => false,
                'desc'          => __('Select a WordPress Page to replace the default SEO Generator archive page.<br>
                                        This page will control its own SEO (titles, meta tags, indexing) independent of the generated SEO pages.<br>
                                        Add the <code>[nsg-archive]</code> shortcode to show the list of generated SEO entries.', 'nsg_seo_generator')
            )
        );

        $enable_noindex_archive_page = new NSG_Meta_Radiobutton_Group_Field(
            array(
                'attr'          => array(
                    'type'      => 'radio',
                    'id'        => "enable_noindex_archive_page",
                ),
                'label'         => __('Exclude Archive Page from Indexing', 'nsg_seo_generator'),
                'wrapper_class' => array('nsg-col', 'nsg-small-12', 'nsg-styled-radios'),
                'radios'       => array(
                    0 => __('No', 'nsg_seo_generator'),
                    1 => __('Yes', 'nsg_seo_generator'),
                ),
                'default'       => 0,
                'is_option'     => false,
                'desc'          => __('Set the archive page to noindex (follow). Prevents the SEO Generator archive page from being indexed by search engines, while still allowing link equity to pass through.<br>
                                        Note: This setting is ignored if you have selected a custom replacement page above.', 'nsg_seo_generator')
            )
        );

		// Create NSG_Meta_Block and add fields
		$config_block = new NSG_Meta_Block();
		$config_block->add_field($seo_page_base_field);
		$config_block->add_field($slug_placeholder_field);
		$config_block->add_field($archive_page_title_field);
        $config_block->add_field($overview_label_field);
        $config_block->add_field($url_example_field);
		$config_block->add_field($nsg_get_search_terms_field);
		$config_block->add_field($nsg_locations_field);
		$config_block->add_field($html_field);
		
        $seo_block = new NSG_Meta_Block();
        $seo_block->add_field($title_tag_field);
		$seo_block->add_field($meta_description_field);

        $archive_block = new NSG_Meta_Block();
        $archive_block->add_field($enable_archive_page);
        $archive_block->add_field($archive_page_behavior);
        $archive_block->add_field($archive_page_redirect_url);
        $archive_block->add_field($enable_custom_archive_page);
        $archive_block->add_field($archive_page_custom_page_id);
        $archive_block->add_field($enable_noindex_archive_page);

        #####################################################################
        ###                      TABLE OF CONTENTS SETTINGS
        #####################################################################

        $enable_toc = new NSG_Meta_Radiobutton_Group_Field(
            array(
                'attr'          => array(
                    'type'      => 'radio',
                    'id'        => "enable_toc",
                ),
                'label'         => __('Enable Table of Contents', 'nsg_seo_generator'),
                'wrapper_class' => array('nsg-col', 'nsg-small-12', 'nsg-styled-radios'),
                'radios'       => array(
                    0 => __('No', 'nsg_seo_generator'),
                    1 => __('Yes', 'nsg_seo_generator'),
                ),
                'default'       => 0,
                'is_option'     => false,
                'desc' => __('Enable automatic Table of Contents generation at the top of all pages generated by this SEO page. Use the [nsg-toc] shortcode for custom placement.', 'nsg_seo_generator')
            )
        );

        $toc_title = new NSG_Meta_Input_Field(
            array(
                'attr'          => array(
                    'type'        => 'text',
                    'id'          => 'toc_title',
                    'placeholder' => __('Table of Contents', 'nsg_seo_generator'),
                    'autocomplete' => 'off'
                ),
                'label'         => __('Table of Contents Title', 'nsg_seo_generator'),
                'wrapper_class' => array('nsg-col', 'nsg-small-12', 'nsg-medium-6'),
                'default'       => __('Table of Contents', 'nsg_seo_generator'),
                'is_option'     => false,
                'desc'          => __('The title to display above the Table of Contents.', 'nsg_seo_generator')
            )
        );

        $toc_numbered = new NSG_Meta_Radiobutton_Group_Field(
            array(
                'attr'          => array(
                    'type'      => 'radio',
                    'id'        => "toc_numbered",
                ),
                'label'         => __('Numbered List', 'nsg_seo_generator'),
                'wrapper_class' => array('nsg-col', 'nsg-small-12', 'nsg-medium-6', 'nsg-styled-radios'),
                'radios'       => array(
                    0 => __('No', 'nsg_seo_generator'),
                    1 => __('Yes', 'nsg_seo_generator'),
                ),
                'default'       => 1,
                'is_option'     => false,
                'desc' => __("Display the Table of Contents as a numbered list.", 'nsg_seo_generator')
            )
        );

        $toc_toggle = new NSG_Meta_Radiobutton_Group_Field(
            array(
                'attr'          => array(
                    'type'      => 'radio',
                    'id'        => "toc_toggle",
                ),
                'label'         => __('Allow Toggle', 'nsg_seo_generator'),
                'wrapper_class' => array('nsg-col', 'nsg-small-12', 'nsg-medium-6', 'nsg-styled-radios'),
                'radios'       => array(
                    0 => __('No', 'nsg_seo_generator'),
                    1 => __('Yes', 'nsg_seo_generator'),
                ),
                'default'       => 1,
                'is_option'     => false,
                'desc' => __("Allow users to show/hide the Table of Contents.", 'nsg_seo_generator')
            )
        );

        $toc_include_h3 = new NSG_Meta_Radiobutton_Group_Field(
            array(
                'attr'          => array(
                    'type'      => 'radio',
                    'id'        => "toc_include_h3",
                ),
                'label'         => __('Include H3 Headings', 'nsg_seo_generator'),
                'wrapper_class' => array('nsg-col', 'nsg-small-12', 'nsg-medium-6', 'nsg-styled-radios'),
                'radios'       => array(
                    0 => __('No', 'nsg_seo_generator'),
                    1 => __('Yes', 'nsg_seo_generator'),
                ),
                'default'       => 1,
                'is_option'     => false,
                'desc' => __("Include H3 headings in addition to H2 headings.", 'nsg_seo_generator')
            )
        );

        $toc_shortcode_info = new NSG_Meta_HTML_Field(
            array(
                'attr'          => array(
                    'id'    => 'toc-shortcode-info',
                    'type'  => 'html'
                ),
                'label'         => __('Shortcode Usage', 'nsg_seo_generator'),
                'wrapper_class' => array('nsg-col', 'nsg-small-12'),
                'desc'          => sprintf(
                    '<div style="background: #f0f6fc; border: 1px solid #c3d7f1; border-radius: 4px; padding: 15px; margin: 10px 0;">
                        <h4 style="margin-top: 0; color: #0073aa;">%s</h4>
                        <p>%s</p>
                        <code>[nsg-toc]</code>
                        <br><br><p style="margin-bottom: 8px;"><strong>%s:</strong> %s</p>
                        <p style="margin-bottom: 0; font-size: 0.9em; color: #666;"><strong>%s:</strong> %s</p>
                    </div>',
                    __('Manual Table of Contents Placement', 'nsg_seo_generator'),
                    __('Use the shortcode below to manually place the Table of Contents anywhere in your content instead of the automatic placement at the top.', 'nsg_seo_generator'),
                    __('Note', 'nsg_seo_generator'),
                    __('The shortcode will only work on individual SEO pages (not on the archive page) and only when "Enable Table of Contents" is set to "Yes".', 'nsg_seo_generator'),
                    __('SEO Benefit', 'nsg_seo_generator'),
                    __('A Table of Contents improves user experience and helps search engines understand your content structure, potentially boosting rankings and increasing time on page.', 'nsg_seo_generator')
                )
            )
        );

        $toc_block = new NSG_Meta_Block();
        $toc_block->add_field($enable_toc);
        $toc_block->add_field($toc_title);
        $toc_block->add_field($toc_numbered);
        $toc_block->add_field($toc_toggle);
        $toc_block->add_field($toc_include_h3);
        $toc_block->add_field($toc_shortcode_info);

        $this->add_block("nsg-config-block",    __('Settings', 'nsg_seo_generator'), $config_block);
        $this->add_block("nsg-archive-block",   __('Archive Page', 'nsg_seo_generator'), $archive_block);
        $this->add_block("nsg-seo-block",       __('SEO', 'nsg_seo_generator'), $seo_block);
        $this->add_block("nsg-toc-block",       __('Table of Contents', 'nsg_seo_generator'), $toc_block);

		// Actions
        add_action('edit_form_after_title', array($this, 'edit_form_after_title'));
		add_action('save_post', array($this, 'save'), 10, 3);
		add_filter('get_sample_permalink_html', '__return_empty_string');	// Hides the Permalink just below the Post title field

		// Remove the permalink from the Screen Options as it is replaced by nsg-seo-page-base field
		remove_meta_box('slugdiv', 'nw_seo_page', 'normal');
	}
    
	/**
	 * Show fake meta box above the_content() editor and make sure it's not sortable, foldable, etc
	 */
    public function edit_form_after_title()
    {
        $this->show();
    }

	/**
	 * Save fields in fake meta box
	 * 
	 * Fires once a post has been saved.
	 *
	 * @param int     $post_id Post ID.
	 * @param WP_Post $post    Post object.
	 * @param bool    $update  Whether this is an existing post being updated.
	 */
	public function save($post_id, $post, $update = null)
	{
		if(
			(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) ||	// prevent the data from being auto-saved
			(!current_user_can('edit_post', $post_id)) || 		// check user permissions
			((!isset($_POST[$this->nonce_name]))) || 			// verify nonce (same with below)
			(!wp_verify_nonce($_POST[$this->nonce_name], basename(__FILE__)))
		)
		{
			return;
		}

        foreach ($this->blocks as $block)
        {
            $block->save();
        }

        $nsg = NSG_Seo_Generator::get_instance();
	    $nsg->nsg_store_search_word_and_location_for_slugs($post_id, true);

		// Workaround to flush the rewrite rules:
		update_option( 'nsg-flush-rewrite-rules', 1 );
	}

	/**
	 * Shows fake meta box with custom NSG_Meta_Field fields
	 */
	public function show()
	{
        // By faking the metabox design with class=postbox, we avoid all problems related to the metabox being sortable, foldable, etc
		printf ("\r\n<div id='%s' class='postbox'>\r\n",
				$this->meta_box_config['id']
			);
		
		printf ("<div class='postbox-header'><h2>%s</h2></div>\r\n",
				$this->meta_box_config['title']
			);

		echo "<div class='inside'>\r\n";
		
		wp_nonce_field(basename(__FILE__), $this->nonce_name);

        echo "\r\n<div class='nsg-meta-box'>\r\n";
		echo "<div id='nsg-tabs' class='nsg-tabs nsg-tabs-horizontal ui-helper-clearfix'>\r\n";

		echo "<ul>\r\n";

		foreach($this->tabs as $tab)
		{
			$tab_id		= $tab[0];
			$tab_title	= $tab[1];
			echo "<li><a href='#nsg-tabs-{$tab_id}'>{$tab_title}</a></li>\r\n";
		}

		echo "</ul>\r\n";

		$index = 0;
		foreach ($this->blocks as $block)
		{
			$tab 	= $this->tabs[$index];
			$tab_id	= $tab[0];

			echo "<div id='nsg-tabs-{$tab_id}' class='nsg-meta-box-panel'>\r\n";
			echo "<div class='nsg-row'>\r\n";

			$block->show();

			echo "</div >\r\n";
			echo "</div >\r\n";

			$index++;
		}

		echo "</div>\r\n";
		echo "</div>\r\n";
		echo "</div>\r\n";
		echo "</div>\r\n";		
	}
}

/**
 * Make sure when Page Builders like Bricks save the SEO Page, the lookup table is updated
 */
add_action( "edit_post_nw_seo_page", 'nsg_wp_ajax_save_post', -99, 2);
function nsg_wp_ajax_save_post($post_id, $post)
{
    $nsg = NSG_Seo_Generator::get_instance();
	$lookup_table = $nsg->nsg_store_search_word_and_location_for_slugs($post_id, true);
}
