<?php

/**
 * Holds NSG_Meta_Field fields to store some settings used by the plugin
 */
class NSG_Settings extends NSG_Tabs
{
	/**
	 * Creates an instance of NSG_Settings
	 */
	public function __construct()
	{
		$meta_box_config = array(
			'id'	=> 'nsg-meta-box-settings',
			'title'	=> __('SEO Generator settings', 'nsg_seo_generator'),
			'context'	=> 'normal',
			'priority'	=> 'core',
			'screen'	=> 'nw_seo_page_page_settings'
		);
		
		$this->nonce_name 		= $meta_box_config['id'] . '_nonce';

		add_action('admin_menu', array($this, 'nsg_admin_menu'));

		if (nsg_is_settings_page())
		{
			add_action('add_meta_boxes', array($this, 'add_meta_boxes'));

			// Load the JavaScript needed for the settings screen
			add_action('admin_enqueue_scripts', array($this, 'nsg_options_page_enqueue_scripts'));
		}
	}

	/**
	 * Adds new submenu page with tabs and fields to hold settings
	 */
	public function nsg_admin_menu()
	{
		// Add settings menu page
		$settings_page = add_submenu_page(
			'edit.php?post_type=nw_seo_page',
			__('Settings', 'nsg_seo_generator'),
			__('Settings', 'nsg_seo_generator'),
			'edit_posts',
			'nsg-settings',
			array($this, 'nsg_settings_page'),
			null
		);

        $this->add_tabs_and_fields($settings_page);
    }

    private function add_tabs_and_fields($settings_page)
    {
		if ($settings_page)
		{
			$nsg = NSG_Seo_Generator::get_instance();

			$search_term_single = new NSG_Meta_Input_Field(
				array(
					'attr'          => array(
						'type'          => 'text',
						'id'    		=> 'search-term-placeholder',
						'placeholder'	=> $nsg->get_search_term_single_placeholder(),
					),
					'label' 		=> __('Search term placeholder', 'nsg_seo_generator'),
					'wrapper_class' => array('nsg-col', 'nsg-small-12 nsg-medium-3'),
					'default'		=> $nsg->get_search_term_single_placeholder(),
					'is_option'		=> true,
					'desc'			=> ''
				)
			);

			$search_term_plural = new NSG_Meta_Input_Field(
				array(
					'attr'          => array(
						'type'          => 'text',
						'id'    		=> 'search-terms-placeholder',
						'placeholder'	=> $nsg->default_search_term_plural_placeholder,
					),
					'label' 		=> __('Search terms (plural) placeholder', 'nsg_seo_generator'),
					'wrapper_class' => array('nsg-col', 'nsg-small-12 nsg-medium-3'),
					'default'		=> $nsg->default_search_term_plural_placeholder,
					'is_option'		=> true,
					'desc'			=> ''
				)
			);

            $enable_search_term_case_sensitivity = new NSG_Meta_Radiobutton_Group_Field(
				array(
					'attr'          => array(
						'type'      => 'radio',
						'id'        => "enable_search_term_case_sensitivity",
					),
					'label'         => __('Enable case sensitive placeholders', 'nsg_seo_generator'),
					'wrapper_class' => array('nsg-col', 'nsg-small-12 nsg-medium-6', 'nsg-styled-radios'),
					'radios'       => array(
						0 => __('No', 'nsg_seo_generator'),
						1 => __('Yes', 'nsg_seo_generator'),
					),
					'default'       => 0,
					'is_option'     => true,
                    'desc'			=> sprintf(
                        __("If enabled you can use %s and %s for the single placeholder.<br>If enabled you can use %s and %s for the plural placeholder.", 'nsg_seo_generator'),
                        strtolower($nsg->get_search_term_single_placeholder()),
                        $nsg->nsg_get_ucfirst_placeholder($nsg->get_search_term_single_placeholder()),
                        strtolower($nsg->get_search_term_plural_placeholder()),
                        $nsg->nsg_get_ucfirst_placeholder($nsg->get_search_term_plural_placeholder())
                    )
				)
			);

			$location_single = new NSG_Meta_Input_Field(
				array(
					'attr'          => array(
						'type'          => 'text',
						'id'    		=> 'location-placeholder',
						'placeholder'	=> $nsg->default_location_single_placeholder,
					),
					'label' 		=> __('Location placeholder', 'nsg_seo_generator'),
					'wrapper_class' => array('nsg-col', 'nsg-small-12 nsg-medium-3'),
					'default'		=> $nsg->default_location_single_placeholder,
					'is_option'		=> true,
					'desc'			=> ''
				)
			);

			$location_plural = new NSG_Meta_Input_Field(
				array(
					'attr'          => array(
						'type'          => 'text',
						'id'    		=> 'locations-placeholder',
						'placeholder'	=> $nsg->default_location_plural_placeholder,
					),
					'label' 		=> __('Locations (plural) placeholder', 'nsg_seo_generator'),
					'wrapper_class' => array('nsg-col', 'nsg-small-12 nsg-medium-3'),
					'default'		=> $nsg->default_location_plural_placeholder,
					'is_option'		=> true,
					'desc'			=> ''
				)
			);

            $enable_location_case_sensitivity = new NSG_Meta_Radiobutton_Group_Field(
				array(
					'attr'          => array(
						'type'      => 'radio',
						'id'        => "enable_location_case_sensitivity",
					),
					'label'         => __('Enable case sensitive placeholders', 'nsg_seo_generator'),
					'wrapper_class' => array('nsg-col', 'nsg-small-12 nsg-medium-6', 'nsg-styled-radios'),
					'radios'       => array(
						0 => __('No', 'nsg_seo_generator'),
						1 => __('Yes', 'nsg_seo_generator'),
					),
					'default'       => 0,
					'is_option'     => true,
                    'desc'			=> sprintf(
                        __("If enabled you can use %s and %s for the single placeholder.<br>If enabled you can use %s and %s for the plural placeholder.", 'nsg_seo_generator'),
                        strtolower($nsg->get_location_single_placeholder()),
                        $nsg->nsg_get_ucfirst_placeholder($nsg->get_location_single_placeholder()),
                        strtolower($nsg->get_location_plural_placeholder()),
                        $nsg->nsg_get_ucfirst_placeholder($nsg->get_location_plural_placeholder())
                    )
				)
			);

			$placeholder_warning_html_field = new NSG_Meta_HTML_Field(
				array(
					'attr'          => array(
						'type'      => 'html',
						'id'    	=> 'placeholders-warning',
					),
					'label'         => __('Placeholders', 'nsg_seo_generator'),
					'wrapper_class' => array('nsg-small-12'),
					'is_option'     => true
				)
			);

            $disable_page_title = new NSG_Meta_Radiobutton_Group_Field(
				array(
					'attr'          => array(
						'type'      => 'radio',
						'id'        => "disable_page_title",
					),
					'label'         => __('Disable template h1-page title', 'nsg_seo_generator'),
					'wrapper_class' => array('nsg-col', 'nsg-small-12', 'nsg-styled-radios'),
					'radios'       => array(
						0 => __('No', 'nsg_seo_generator'),
						1 => __('Yes', 'nsg_seo_generator'),
					),
					'default'       => 0,
					'is_option'     => true,
                    'desc'			=> __("Hides the default page title. Useful when your Page Builder already adds its own <code>&lt;h1&gt;</code> title.", 'nsg_seo_generator'),
				)
			);

			$enable_adjacent_seo_pages_links = new NSG_Meta_Radiobutton_Group_Field(
				array(
					'attr'          => array(
						'type'      => 'radio',
						'id'        => "enable_adjacent_seo_pages_links",
					),
					'label'         => __('Enable adjacent SEO pages links', 'nsg_seo_generator'),
					'wrapper_class' => array('nsg-col', 'nsg-small-12', 'nsg-styled-radios'),
					'radios'       => array(
						0 => __('No', 'nsg_seo_generator'),
						1 => __('Yes', 'nsg_seo_generator'),
					),
					'default'       => 1,
					'is_option'     => true
				)
			);

			$include_styling = new NSG_Meta_Radiobutton_Group_Field(
				array(
					'attr'          => array(
						'type'      => 'radio',
						'id'        => "include_front_end_styling",
					),
					'label'         => __('Include styling', 'nsg_seo_generator'),
					'wrapper_class' => array('nsg-col', 'nsg-small-12', 'nsg-styled-radios'),
					'radios'       => array(
						0 => __('No', 'nsg_seo_generator'),
						1 => __('Yes', 'nsg_seo_generator'),
					),
					'default'       => 1,
					'is_option'     => true
				)
			);

            $enable_canonical_tag = new NSG_Meta_Radiobutton_Group_Field(
				array(
					'attr'          => array(
						'type'      => 'radio',
						'id'        => "enable_canonical_tag",
					),
					'label'         => __('Enable SEO Generator canonical tag', 'nsg_seo_generator'),
					'wrapper_class' => array('nsg-col', 'nsg-small-12', 'nsg-styled-radios'),
					'radios'       => array(
						0 => __('No', 'nsg_seo_generator'),
						1 => __('Yes', 'nsg_seo_generator'),
					),
					'default'       => 0,
					'is_option'     => true
				)
			);
            
            $enable_custom_excerpt_tag = new NSG_Meta_Radiobutton_Group_Field(
				array(
					'attr'          => array(
						'type'      => 'radio',
						'id'        => "enable_custom_excerpt_tag",
					),
					'label'         => __('Enable custom excerpt', 'nsg_seo_generator'),
					'wrapper_class' => array('nsg-col', 'nsg-small-12  nsg-medium-6', 'nsg-styled-radios'),
					'radios'       => array(
						0 => __('No', 'nsg_seo_generator'),
						1 => __('Yes', 'nsg_seo_generator'),
					),
					'default'       => 0,
					'is_option'     => true
				)
			);

            $custom_excerpt_length = new NSG_Meta_Input_Field(
				array(
					'attr'          => array(
						'type'          => 'number',
						'id'    		=> 'custom_excerpt_length',
						'placeholder'	=> $nsg->get_search_term_single_placeholder(),
					),
					'label' 		=> __('Cusomt excerpt length', 'nsg_seo_generator'),
					'wrapper_class' => array('nsg-col', 'nsg-small-12 nsg-medium-6'),
					'default'		=> 55,
					'is_option'		=> true,
					'desc'			=> __('Number of words', 'nsg_seo_generator')
				)
			);

            $enable_adjacent_seo_pages_links = new NSG_Meta_Radiobutton_Group_Field(
				array(
					'attr'          => array(
						'type'      => 'radio',
						'id'        => "enable_adjacent_seo_pages_links",
					),
					'label'         => __('Enable adjacent SEO pages links', 'nsg_seo_generator'),
					'wrapper_class' => array('nsg-col', 'nsg-small-12', 'nsg-styled-radios'),
					'radios'       => array(
						0 => __('No', 'nsg_seo_generator'),
						1 => __('Yes', 'nsg_seo_generator'),
					),
					'default'       => 1,
					'is_option'     => true
				)
			);

            #####################################################################
            ###                      SPINTAX SETTINGS
            #####################################################################

            $enable_spintax = new NSG_Meta_Radiobutton_Group_Field(
				array(
					'attr'          => array(
						'type'      => 'radio',
						'id'        => "enable_spintax",
					),
					'label'         => __('Enable spintax', 'nsg_seo_generator'),
					'wrapper_class' => array('nsg-col', 'nsg-small-12', 'nsg-styled-radios'),
					'radios'       => array(
						0 => __('No', 'nsg_seo_generator'),
						1 => __('Yes', 'nsg_seo_generator'),
					),
					'default'       => 0,
					'is_option'     => true
				)
			);

            $randomize_spintax = new NSG_Meta_Radiobutton_Group_Field(
				array(
					'attr'          => array(
						'type'      => 'radio',
						'id'        => "randomize_spintax",
					),
					'label'         => __('Spintax rotation', 'nsg_seo_generator'),
					'wrapper_class' => array('nsg-col', 'nsg-small-12', 'nsg-styled-radios'),
					'radios'       => array(
						0 => __('Sequential', 'nsg_seo_generator'),
						1 => __('Random', 'nsg_seo_generator'),
                        2 => __('Random Persistent', 'nsg_seo_generator'),
					),
					'default'       => 0,
					'is_option'     => true,
                    'desc'          => __("<strong>Random: </strong> Generate a random combination of the text each time. Adds variability and freshness to the content, as the combination will be different on each page load.<br><strong>Sequential:</strong> Generate a specific combination based on which SEO Page is shown. Ensures consistency where each page has a unique and fixed version of the text.<br><strong>Random Persistent: </strong>Generate a random variation once and keep it fixed for that page. Ensures consistent output with initial randomness. <strong>(Recommended)</strong>", 'nsg_seo_generator')
				)
			);

            $sitemap_name = new NSG_Meta_Input_Field(
				array(
					'attr'          => array(
						'type'          => 'text',
						'id'    		=> 'sitemap_name',
						'placeholder'	=> 'seo_generator_sitemap',
					),
					'label' 		=> __('Sitemap name', 'nsg_seo_generator'),
					'wrapper_class' => array('nsg-col', 'nsg-small-12'),
					'default'		=> 'seo_generator_sitemap',
					'is_option'		=> true,
					'desc'			=> __("Do not forget to visit your Permalinks when you change the Sitemap name!", 'nsg_seo_generator')
				)
			);

			$html_field = new NSG_Meta_HTML_Field(
				array(
					'attr'          => array(
						'type'      => 'html',
						'id'    	=> 'sitemap',
					),
					'label'         => __('Sitemap', 'nsg_seo_generator'),
					'wrapper_class' => array('nsg-small-12'),
					'is_option'     => true
				)
			);
            
            // Shortcodes explanation
			$shortcodes_information_html_field = new NSG_Meta_HTML_Field(
				array(
					'attr'          => array(
						'type'      => 'html',
						'id'    	=> 'shortcodes-information',
					),
					'label'         => __('Shortcodes', 'nsg_seo_generator'),
					'wrapper_class' => array('nsg-small-12'),
                    'is_option'     => true,
				)
			);

			$settings_general = new NSG_Meta_Block();

			$settings_general->add_field($placeholder_warning_html_field);
			
			$settings_general->add_field($search_term_single);
			$settings_general->add_field($search_term_plural);
            $settings_general->add_field($enable_search_term_case_sensitivity);

			$settings_general->add_field($location_single);
			$settings_general->add_field($location_plural);
            $settings_general->add_field($enable_location_case_sensitivity);

            $settings_general->add_field($disable_page_title);
			$settings_general->add_field($enable_adjacent_seo_pages_links);
			$settings_general->add_field($include_styling);
            $settings_general->add_field($enable_canonical_tag);

            $settings_general->add_field($enable_custom_excerpt_tag);
            $settings_general->add_field($custom_excerpt_length);

            $spintax_block = new NSG_Meta_Block();
            $spintax_block->add_field($enable_spintax);
            $spintax_block->add_field($randomize_spintax);

			$sitemap_block = new NSG_Meta_Block();
            $sitemap_block->add_field($sitemap_name);
			$sitemap_block->add_field($html_field);

			$shortcodes_block = new NSG_Meta_Block();
            $shortcodes_block->add_field($shortcodes_information_html_field);
            
            $this->add_block("nsg-settings-general", __('Settings', 'nsg_seo_generator'), $settings_general);
            $this->add_block("nsg-settings-spintax", __('Spintax', 'nsg_seo_generator'), $spintax_block);
			$this->add_block("nsg-settings-sitemap", __('Sitemap', 'nsg_seo_generator'), $sitemap_block);
            $this->add_block("nsg-settings-shortcodes", __('Shortcodes', 'nsg_seo_generator'), $shortcodes_block);
		}
	}

	/**
	 * Loads script needed for the Metabox
	 * 
	 * @param string $hook_suffix The current admin page.
	 */
	public function nsg_options_page_enqueue_scripts($hook_suffix)
	{
		$page_hook_id = $this->nsg_settings_page_id;

		if ($hook_suffix == $page_hook_id)
		{
			wp_enqueue_script( 'common' );
			wp_enqueue_script( 'wp-lists' );
			wp_enqueue_script( 'postbox' );
		}
	}

	/**
	 * Settings Page Callback
	 */
	function nsg_settings_page()
	{
		$hook_suffix = $this->nsg_settings_page_id;
		
		// enable add_meta_boxes function in this page.
		do_action('add_meta_boxes', $hook_suffix, false );
	?>
		<div class="wrap">
			<h2><?php _e('SEO Generator Settings', 'nsg_seo_generator'); ?></h2>

			<?php settings_errors(); ?>

			<div class="nsg-settings-meta-box-wrap">

				<form id="nsg-form" method="post" action="options.php">

					<?php settings_fields( 'nsg' ); // options group  ?>
					<?php wp_nonce_field( 'closedpostboxes', 'closedpostboxesnonce', false ); ?>
					<?php wp_nonce_field( 'meta-box-order', 'meta-box-order-nonce', false ); ?>

					<div id="poststuff">

						<div id="post-body" class="metabox-holder columns-<?php echo 1 == get_current_screen()->get_columns() ? '1' : '2'; ?>">

							<div id="postbox-container-1" class="postbox-container">
								<?php do_meta_boxes( $hook_suffix, 'side', null ); ?>
							</div>

							<div id="postbox-container-2" class="postbox-container">
								<?php do_meta_boxes( $hook_suffix, 'normal', null ); ?>
								<?php do_meta_boxes( $hook_suffix, 'advanced', null ); ?>
							</div>

						</div>
						<br class="clear">
					</div>
				</form>
			</div>
		</div>
	<?php
	}

	/**
	 * Adds meta boxes
	 */
	public function add_meta_boxes()
	{
		$page_hook_id = $this->nsg_settings_page_id;

		// Save Options page meta box on the right side:
		add_meta_box(
			'submitdiv',               
			__('Save options', 'nsg_seo_generator'),
			array($this, 'nsg_submit_meta_box'),
			$page_hook_id,
			'side',
			'high'
		);

		add_meta_box(
			'nsg-settings',
			__('SEO Generator settings', 'nsg_seo_generator'),
			array($this, 'show'),
			$page_hook_id,
			'normal',
			'default'
		);
	}

	/**
	 * Submit meta box callback
	 */
	public function nsg_submit_meta_box()
	{
	?>
	<div id="submitpost" class="submitbox">
		<div id="major-publishing-actions">
			<div id="publishing-action">
				<span class="spinner"></span>
				<?php submit_button( esc_attr( 'Save' ), 'primary', 'submit', false );?>
			</div>
			<div class="clear"></div>
		</div>
	</div>

	<?php
	}

	
}

add_action('init', 'init_nsg_settings');
function init_nsg_settings()
{
	if (is_admin())
	{
		new NSG_Settings();
	}
}

function nsg_populate_page_dropdown($options)
{
	$pages = get_pages(
        array(
            'post_type'     => 'page',
            'post_status'   => 'publish',
            'number'        => 0            //Default 0, or all pages
            )
    );

	foreach ($pages as $page)
	{
		$options[$page->ID] = $page->post_title;
	}

	return $options;
}
