<?php

class NSG_Tabs
{
    /**
	 * List of tabs labels
	 * 
	 * @var array 
	 */
	protected $tabs	= array();

	/**
	 * List of tab panels with NSG_Meta_Field fields
	 * 
	 * @var array 
	 */
	protected $blocks = array();

	/**
	 * Nonce value that was used for verification, usually via a form field.
	 * 
	 * @var string
	 */
	protected $nonce_name;

	/**
	 * Metabox ID
	 * 
	 * @var string
	 */
	protected $nsg_settings_page_id = 'nw_seo_page_page_nsg-settings';

    /**
	 * Adds NSG_Meta_Block
	 * 
	 * @param int				$tab_id		The tab ID
	 * @param string			$tab_title	The tab title
	 * @param NSG_Meta_Block 	$block		The tab pabel content with a NSG_Meta_Block object
	 */
	protected function add_block($tab_id, $tab_title, $block)
	{
		if (apply_filters('nsg-add-block', true, $tab_id, $tab_title, $block))
		{
			$this->tabs[]	= array($tab_id, $tab_title);
			$this->blocks[]	= $block;
		}
	}

    /**
	 * Shows fake meta box with tabs and tab panels with custom NSG_Meta_Field fields
	 */
	public function show()
	{
		wp_nonce_field(basename(__FILE__), $this->nonce_name);

		echo "\r\n<div class='nsg-meta-box'>\r\n";
		echo "<div id='nsg-tabs' class='nsg-tabs ui-helper-clearfix'>\r\n";

		echo "<ul>\r\n";

		foreach($this->tabs as $tab)
		{
			$tab_id		= $tab[0];
			$tab_title	= $tab[1];
			echo "<li><a href='#nsg-tabs-{$tab_id}'>{$tab_title}</a></li>\r\n";
		}

		echo "</ul>\r\n";

		$index = 0;
		foreach ($this->blocks as $block)
		{
			$tab 	= $this->tabs[$index];
			$tab_id	= $tab[0];

			echo "<div id='nsg-tabs-{$tab_id}' class='nsg-meta-box-panel'>\r\n";
			echo "<div class='nsg-row'>\r\n";

			$block->show();

			echo "</div >\r\n";
			echo "</div >\r\n";

			$index++;
		}

		echo "</div>\r\n";
		echo "</div>\r\n";
	}

}