<?php

// Register Custom Post Type: nw_seo_page
add_action( 'init', 'nsg_register_cpt_nw_seo_page', -99999 );
function nsg_register_cpt_nw_seo_page()
{
    $supports   = array( 'title','editor', 'thumbnail', 'revisions', 'author');
    if (get_option('nsg-enable_custom_excerpt_tag', false))
    {
        $supports[] = 'excerpt';
    }

	$labels = array(
		"name"                  => _x("SEO Generator", 'Post type general name', 'nsg_seo_generator'),
		"singular_name"         => _x("SEO Page", 'Post type singular name', 'nsg_seo_generator'),
		"menu_name"             => _x("SEO Generator", 'Admin Menu text', 'nsg_seo_generator'),
		"name_admin_bar"        => _x("SEO Generator", 'Add New on Toolbar', 'nsg_seo_generator'),
		"archives"              => __("SEO Pages", 'nsg_seo_generator'),
		"all_items"             => __("All SEO Pages", 'nsg_seo_generator'),
		"add_new_item"          => __("Add new SEO Page", 'nsg_seo_generator'),
		"add_new"               => __("Add new SEO Page", 'nsg_seo_generator'),
		"new_item"              => __("New SEO Page", 'nsg_seo_generator'),
		"edit_item"             => __("Edit SEO Page", 'nsg_seo_generator'),
		"update_item"           => __("Update SEO Page", 'nsg_seo_generator'),
		"view_item"             => __("View SEO Page", 'nsg_seo_generator'),
		"view_items"            => __("View SEO Pages", 'nsg_seo_generator'),
		"search_items"          => __("Search SEO Pages", 'nsg_seo_generator')
	);
	$args = array(
		'label'                 => __("SEO Page", 'nsg_seo_generator'),
		'labels'                => $labels,
		'supports'              => $supports,
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 25,
		'menu_icon'             => 'dashicons-format-gallery',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => false,
		'feeds'					=> false,
		'exclude_from_search'   => true,
		'publicly_queryable'    => true,
		'capability_type'       => 'post',
		'show_in_rest'          => false,	// No Gutenberg support just yet as there is no room for our custom meta boxes
		'rewrite'               => array(
			// remove extra words added in the Permalinks > Custom Structure. Example /posts_front_slug/%postname%/ would become /posts_front_slug/webdesign/ for a CPT nw_seo_page post Webdesign
			// we want to remove the WP_Rewrite::$front 'posts_front_slug' from the url by setting 'with_front' to false:
            'with_front'    => false	
        )
	);
	register_post_type( 'nw_seo_page', $args );
}

