<?php

if (is_admin())
{
    /**
     * Fires as an admin screen or script is being initialized.
     */
    add_action('admin_init', 'nsg_init_nsg_meta_boxes');
}

/**
 * Creates Config Meta box with base slug, search terms and locations
 */
function nsg_init_nsg_meta_boxes()
{
    $post_id    = nsg_get_valid_post_id();

    $load_nsg   = false;
    if ((int)$post_id > 0 && get_post_type((int)$post_id) === 'nw_seo_page')
    {
        $load_nsg   = true;
    }
    else if (!$post_id)
    {
        global $pagenow;
        if (($pagenow === 'edit.php' || $pagenow === 'post-new.php') && isset($_GET['post_type']) && $_GET['post_type'] === 'nw_seo_page')
        {
            $load_nsg   = true;
        }
    }

    // Only load on Post Edit screen of CPT = nw_seo_page and CPT overview
    if ($load_nsg)
    {
        new NSG_Config();
    }
}
