<?php

if (!is_admin())
{
    // https://rankmath.com/kb/filters-hooks-api-developer/
    add_filter( 'rank_math/frontend/title', 'nsg_get_seo_pages_replace_search_terms_and_locations', 9999999, 1);
    add_filter( 'rank_math/frontend/description', 'nsg_get_seo_pages_replace_search_terms_and_locations', 9999999, 1);
    add_filter( 'rank_math/frontend/canonical', 'nsg_get_seo_pages_replace_search_terms_and_locations', 9999999, 1);
    add_action( 'rank_math/head', 'nsg_rank_math_head', 10, 0);

    // Disable meta og"image tag
    add_filter( 'rank_math/opengraph/pre_set_content_image', 'nsg_rank_math_opengraph_pre_set_content_image', 99999999, 1);

    // Add SEO Generator sitemap to the Rank Math Sitemap
    // add_filter( 'rank_math/sitemap/index', 'nsg_rank_math_sitemap_index', 11, 1);   
}

function nsg_rank_math_head()
{
    if (nsg_is_nsg_page())
    {
        // Remove Facebook and Twitter meta opengraph tags
        remove_all_actions( 'rank_math/opengraph/facebook' );
        remove_all_actions( 'rank_math/opengraph/twitter' );

        // Remove remove json+ld data
        global $wp_filter;
        if ( isset( $wp_filter["rank_math/json_ld"] ) )
        {
            unset( $wp_filter["rank_math/json_ld"] );
        }
    }
}

function nsg_rank_math_opengraph_pre_set_content_image($result)
{
    if (nsg_is_nsg_page())
    {
        $result = true;
    }

    return $result;
}

// function nsg_rank_math_sitemap_index($xml)
// {
//     $xml .= '
//         <sitemap>
//             <loc>' . nsg_get_sitemap_url() . '</loc>
//             <lastmod>' . nsg_get_last_modified_gmt() . '</lastmod>
//         </sitemap>';
//     return $xml;
// }

add_filter( 'rank_math/frontend/canonical', 'nsg_rank_math_frontend_canonical', 10, 1);
function nsg_rank_math_frontend_canonical($canonical)
{
    if (nsg_is_nsg_page())
    {
        // SEO Generator > Settings > Disable Rank Math canonical tag
        if (get_option('nsg-disable_rank_math_canonical_tag', true))
        {
            // Disable Rank Math canonical tag
            $canonical = false;
        }
        else
        {
            // Fix the Rank Math canonical url as [search_term]-in-[location] is url encoded to %5Bsearch_term%5D-in-%5Blocation%5D when the page is saved

            // First decode
            $canonical = urldecode($canonical);

            // Now search and replace
            $canonical = nsg_get_seo_pages_replace_search_terms_and_locations($canonical);

            // Make sure everything is lowercase
            $canonical = strtolower($canonical);
        }
    }
	return $canonical;
}
