<?php

// Handle shortcode logic
function nsg_handle_nsg_seo_page_shortcode($atts, $content = null)
{
    $atts = shortcode_atts(
        array(
            'location'     => '',
            'search_term'  => '',
        ),
        $atts,
        'nsg_seo_page'
    );

    $result         = '';
    $search_term    = $atts['search_term'];     // Single
    $location       = $atts['location'];        // Single
    
    $search_terms   = !empty($search_term)  ? array_map('trim', explode('|', $search_term)) : array();
    $locations      = !empty($location)     ? array_map('trim', explode('|', $location)) : array();

    if (!empty($search_term) || !empty($search_terms) || !empty($location) || !empty($locations))
    {
        $nsg                    = NSG_Seo_Generator::get_instance();
        $search_term_and_slug   = $nsg->nsg_get_search_word_and_location_from_slug(get_the_ID());

        if (is_array($search_term_and_slug) && count($search_term_and_slug) >= 2 && !empty($search_term_and_slug[0]) && !empty($search_term_and_slug[1]))
        {

            // Fetch the current search term and location for this SEO Page url we are viewing
            $the_search_term    = html_entity_decode(stripslashes($search_term_and_slug[0]), ENT_QUOTES); // Single
            $the_location       = html_entity_decode(stripslashes($search_term_and_slug[1]), ENT_QUOTES); // Single

            // Create an array of matching rules
            $matching_conditions = array(
                ['values' => $search_terms,   'compare' => $the_search_term],
                ['values' => $locations,      'compare' => $the_location],
            );

            // Check if all conditions match
            $all_match = true;

            foreach ($matching_conditions as $condition)
            {
                // Skip if no values to compare
                if (empty($condition['values']))
                {
                    continue;
                }

                // Check if any of the values match the compare value
                if (!in_array($condition['compare'], $condition['values']))
                {
                    $all_match = false;
                    break; // Stop as soon as one mismatch is found
                }
            }

            // Assign content if all non-empty conditions match
            if ($all_match)
            {
                $result = $content;
            }
        }
        
    }
    return $result;
}

// Register the new shortcode nsg_seo_page
add_shortcode('nsg_seo_page', 'nsg_handle_nsg_seo_page_shortcode');
