<?php

add_filter('plugins_api',                   'nsg_custom_plugin_info', 20, 3);
add_filter('site_transient_update_plugins', 'nsg_custom_check_for_update');
add_filter('upgrader_post_install',         'nsg_custom_after_update', 10, 3);

function nsg_custom_plugin_info($false, $action, $args)
{
    if ($action !== 'plugin_information' || $args->slug !== 'nsg-seo-generator')
    {
        return $false;
    }

    $remote = wp_remote_get('https://seogenerator.io/wp-content/plugins/nsg-updates-license-manager/update-info.json');
    if (is_wp_error($remote) || 200 !== wp_remote_retrieve_response_code($remote))
    {
        return new WP_Error('plugins_api_failed', 'Could not retrieve plugin information.');
    }

    $info = json_decode(wp_remote_retrieve_body($remote));

    if (empty($info))
    {
        return new WP_Error('plugins_api_failed', 'Invalid plugin information received.');
    }

    return (object) array(
        'name'          => 'SEO Generator',
        'slug'          => 'nsg-seo-generator',
        'version'       => $info->version,
        'requires'      => $info->requires,
        'tested'        => $info->tested,
        'download_link' => $info->download_url,
        'author'        => '<a href="https://seogenerator.io">SEO Generator</a>',
        'author_profile'=> 'https://seogenerator.io',
        'homepage'      => 'https://seogenerator.io',
        'sections'      => array(
            'description'   => 'Generate SEO landingpages based on different search terms and locations.',
            'changelog'     => 'https://seogenerator.io/changelog/'
        ),
    );
}

function nsg_custom_check_for_update($transient)
{
    if (empty($transient->checked)) {
        return $transient;
    }

    $remote = wp_remote_get('https://seogenerator.io/wp-content/plugins/nsg-updates-license-manager/update-info.json');
    if (is_wp_error($remote) || 200 !== wp_remote_retrieve_response_code($remote)) {
        return $transient;
    }

    $info = json_decode(wp_remote_retrieve_body($remote));
    $plugin_file = 'nsg-seo-generator/nowweb-seo-generator.php'; // Adjust as needed.

    if (version_compare($transient->checked[$plugin_file], $info->version, '<')) {
        $transient->response[$plugin_file] = (object) array(
            'slug'        => 'nsg-seo-generator',
            'plugin'      => $plugin_file,
            'new_version' => $info->version,
            'package'     => $info->download_url,
            'url'         => 'https://seogenerator.io', // Plugin info URL.
        );
    }

    return $transient;
}

function nsg_custom_after_update($response, $hook_extra, $result)
{
    if (!empty($hook_extra['plugin']) && $hook_extra['plugin'] === 'nsg-seo-generator/nowweb-seo-generator.php') {
        // Perform post-update cleanup or operations.
    }
    return $response;
}
