<?php

/**
 * Plugin Name:             SEO Generator
 * Plugin URI:              https://seogenerator.io/
 * Description:             Generate SEO landingpages based on different search terms and locations.
 * Version:                 2.11.2
 * Author:                  seogenerator.io
 * Author URI:              https://seogenerator.io/
 * Text Domain:             nsg_seo_generator
 * Domain Path:             /languages
 * 
 * Copyright:               © 2025 seogenerator.io
 * License:                 GNU General Public License v3.0
 * License URI:             http://www.gnu.org/licenses/gpl-3.0.html
 */

defined('ABSPATH') or die();

define('NSG_PLUGIN_VERSION', '2.11.2');

add_action('init', 'nsg_plugin_init', -999999);
function nsg_plugin_init()
{
    load_plugin_textdomain('nsg_seo_generator', false, 'nsg-seo-generator/languages');
    
    // Initialize TOC functionality
    if (class_exists('NSG_Table_Of_Contents')) {
        NSG_Table_Of_Contents::get_instance();
    }
}

/**
 * Activate the plugin.
 */
register_activation_hook( __FILE__, 'nsg_activate' );
function nsg_activate()
{ 
    // Register CPT
    nsg_register_cpt_nw_seo_page();

    // Create a demo page to showcase the plugin functionalities
    nsg_create_seo_gen_example_page();

    // Clear the permalinks after CPT has been registered
    flush_rewrite_rules(); 

    // Setup cronjobs
    // nsg_cron_job_handler(true); // DISABLED
}
 
/**
 * Deactivation hook.
 */
register_deactivation_hook( __FILE__, 'nsg_deactivate' );
function nsg_deactivate()
{
    // Unregister the CPT, so the rules are no longer in memory
    unregister_post_type( 'nw_seo_page' );

    // Clear the permalinks to remove our CPTs rules from the database.
    flush_rewrite_rules();

    // Cleanup cronjobs
    // nsg_cron_job_handler(false); // DISABLED
    
    // Clear the cronjob
    wp_clear_scheduled_hook('nsg_weekly_cronjob');
}

function nsg_get_plugin_dir()
{
    $nsg_seo_generator_dir = plugin_dir_path(__FILE__);
    return $nsg_seo_generator_dir;
}

function nsg_get_plugin_url()
{
    $nsg_seo_generator_url = plugins_url('nsg-seo-generator');
    return $nsg_seo_generator_url;
}

function nsg_get_plugin_basename()
{
    $nsg_seo_generator_basename = plugin_basename(__FILE__);
    return $nsg_seo_generator_basename;
}

$nsg_seo_generator_dir = nsg_get_plugin_dir();
$nsg_seo_generator_url = nsg_get_plugin_url();

require_once "{$nsg_seo_generator_dir}includes/field-filters.php";

require_once "{$nsg_seo_generator_dir}includes/admin.php";
require_once "{$nsg_seo_generator_dir}includes/url-rewrites.php";
require_once "{$nsg_seo_generator_dir}includes/content-filters.php";
require_once "{$nsg_seo_generator_dir}includes/archive-page-functions.php";
require_once "{$nsg_seo_generator_dir}includes/custom-post-type.php";
require_once "{$nsg_seo_generator_dir}includes/functions.php";

require_once "{$nsg_seo_generator_dir}includes/shortcode_seo_page.php";

require_once "{$nsg_seo_generator_dir}includes/class.nsg-tabs.php";
require_once "{$nsg_seo_generator_dir}includes/class.nsg-config.php";
require_once "{$nsg_seo_generator_dir}includes/class.nsg-meta-block.php";
require_once "{$nsg_seo_generator_dir}includes/class.nsg-meta-block-fields.php";
require_once "{$nsg_seo_generator_dir}includes/class.nsg-spintax.php";

require_once "{$nsg_seo_generator_dir}includes/class.nsg.php";
require_once "{$nsg_seo_generator_dir}includes/class.nsg-toc.php";
require_once "{$nsg_seo_generator_dir}includes/class.nsg-settings.php";
require_once "{$nsg_seo_generator_dir}includes/class.nsg-documentation.php";
require_once "{$nsg_seo_generator_dir}includes/nsg-meta-boxes.php";

require_once "{$nsg_seo_generator_dir}includes/compatibility.php";

