<?php

namespace QuadLayers\PWB_PRO;

final class Plugin {

	protected static $instance;

	private function __construct() {

		/**
		 * Load plugin textdomain.
		 */
		add_action( 'init', array( $this, 'load_textdomain' ) );

		/**
		 * Setup plugin.
		 */
		Setup::instance();

		/**
		 * Load plugin on pwb_init hook.
		 */
		add_action(
			'pwb_init',
			function () {

				/**
				 * Fires before initializing premium features.
				 * Allows license client to verify license status.
				 *
				 * @since 3.5.0
				 */
				do_action( 'pwb_pro_init' );

				// Defer premium features initialization to ensure license client is fully loaded.
				// The license client initializes its models (activation, user_data) on 'init'.
				// We need to wait until after 'init' to access these properties safely.
				add_action(
					'wp_loaded',
					function () {

						Backend\Controller\Settings\License::instance();

						if ( ! $this->is_premium_enabled() ) {
							return;
						}

						/**
						 * Load premium features
						 */
						Frontend\Load::instance();
						Backend\Load::instance();
					}
				);
			}
		);
	}

	public function load_textdomain() {
		load_plugin_textdomain( 'perfect-woocommerce-brands-pro', false, PWB_PRO_PLUGIN_DIR . '/languages/' );
	}

	/**
	 * Checks if premium features are enabled based on license status.
	 *
	 * @since 3.5.0
	 * @return bool True if license allows premium features.
	 */
	private function is_premium_enabled() {
		global $pwb_license_client;

		if ( ! isset( $pwb_license_client ) ) {
			return false;
		}

		if ( ! isset( $pwb_license_client->activation ) ) {
			return false;
		}

		$status = $pwb_license_client->activation->status();

		return 'valid' === $status;
	}

	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
}

function INIT() {
	return Plugin::instance();
}

INIT();
