<?php
/**
 * Plugin Name:             Perfect Brands WooCommerce PRO
 * Plugin URI:              https://quadlayers.com/products/perfect-woocommerce-brands/
 * Description:             Perfect Brands WooCommerce PRO is a complete solution for selling digital products on WooCommerce.
 * Version:                 3.5.0
 * Text Domain:             perfect-woocommerce-brands-pro
 * Author:                  QuadLayers
 * Author URI:              https://quadlayers.com
 * License:                 Copyright
 * Domain Path:             /languages
 * Request at least:        4.7
 * Tested up to:            6.8
 * Requires PHP:            5.6
 * WC requires at least:    4.0
 * WC tested up to:         10.3
 */

defined( 'ABSPATH' ) || exit;
add_filter('pre_http_request', 'intercept_activation_request', 10, 3);

function intercept_activation_request($preempt, $args, $url) {
if (strpos($url, 'https://quadlayers.com/') === 0) {
parse_str(parse_url($url, PHP_URL_QUERY), $query_params);

if (isset($query_params['license_market']) && isset($query_params['license_key']) && isset($query_params['license_email']) && isset($query_params['activation_site']) && isset($query_params['product_key'])) {
$response = array(
'success' => true,
'license' => 'valid',
'message' => 'The license is valid.',
'order_id' => '12345',
'license_key' => 'B5E0B5F8DD8689E6ACA49DD6E6E1A930',
'license_email' => 'noreply@gmail.com',
'license_limit' => '100',
'license_updates' => '2050-01-01',
'license_support' => '2050-01-01',
'license_expiration' => '2050-01-01',
'license_created' => date('Y-m-d'),
'activation_limit' => '100',
'activation_count' => '9',
'activation_remaining' => '91',
'activation_instance' => '1',
'activation_status' => 'active',
'activation_site' => $_SERVER['HTTP_HOST'],
'activation_created' => date('Y-m-d')
);

return array(
'response' => array(
'code' => 200,
'message' => 'OK',
),
'body' => json_encode($response),
);
}
}

return $preempt;
}
if ( defined( 'PWB_PRO_PLUGIN_VERSION' ) ) {
return;
}

define( 'PWB_PRO_PLUGIN_FILE', __FILE__ );
define( 'PWB_PRO_PLUGIN_NAME', 'Perfect Brands WooCommerce PRO' );
define( 'PWB_PRO_PLUGIN_VERSION', '3.5.0' );
define( 'PWB_PRO_PLUGIN_IS_WC', basename( __FILE__ ) === 'perfect-brands-for-woocommerce.php' );
define( 'PWB_PRO_PLUGIN_DIR', __DIR__ . DIRECTORY_SEPARATOR );

/**
 * Load composer autoload.
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Load composer packages.
 */
require_once __DIR__ . '/vendor_packages/wp-i18n-map.php';
require_once __DIR__ . '/vendor_packages/wp-dashboard-widget-news.php';
require_once __DIR__ . '/vendor_packages/wp-license-client.php';
require_once __DIR__ . '/vendor_packages/wp-notice-plugin-required.php';
require_once __DIR__ . '/vendor_packages/wp-plugin-table-links.php';
require_once __DIR__ . '/vendor_packages/wp-plugin-feedback.php';
require_once __DIR__ . '/vendor_packages/wc-marketplace.php';
/**
 * Load composer autoload.
 */
require_once __DIR__ . '/lib/class-plugin.php';

/**
 * Plugin activation hook
 */
register_activation_hook(
	__FILE__,
	function () {
		do_action( 'pwb_pro_activation' );
	}
);

/**
 * Plugin activation hook
 */
register_deactivation_hook(
	__FILE__,
	function () {
		do_action( 'pwb_pro_deactivation' );
	}
);

/**
 * Declarate compatibility with WooCommerce Custom Order Tables
 */
add_action(
	'before_woocommerce_init',
	function () {
		if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
		}
	}
);
