<?php

if ( !PWB_PRO_PLUGIN_IS_WC && class_exists( 'QuadLayers\\WP_License_Client\\Load' ) ) {

	/**
	 * Initialize license client on 'pwb_pro_init' hook.
	 * This hook is fired BEFORE the Pro plugin decides whether to initialize,
	 * allowing the license client to verify license status first.
	 *
	 * @since 3.5.0
	 */
	add_action(
		'pwb_pro_init',
		function () {
			global $pwb_license_client;

			if ( ! isset( $pwb_license_client ) ) {

				$pwb_license_client = new QuadLayers\WP_License_Client\Load(
					array(
						'api_url'           => 'https://quadlayers.com/wp-json/wc/wlm/',
						'product_key'       => '471326cbfb539d48d91e7fa51ff987bb',
						'parent_menu_slug'  => 'wc-settings',
						'license_menu_slug' => 'pwb_license',
						'license_key_url'   => 'https://quadlayers.com/account/licenses/?utm_source=pwb_plugin_pro&utm_medium=dashboard_notice&utm_campaign=license&utm_content=license_key_link',
						'support_url'       => 'https://quadlayers.com/account/support/?utm_source=pwb_plugin_pro&utm_medium=plugin_table&utm_campaign=support&utm_content=support_link',
						'plugin_file'       => PWB_PRO_PLUGIN_FILE,
					)
				);
			}

			return $pwb_license_client;
		},
		5 // Priority 5: Execute BEFORE the Pro plugin's callback (default priority 10).
	);
}
