"use strict";

/**
 * ------------------------------------------------------------------------------
 * Based on Edit Flow
 * Author: Daniel Bachhuber, Scott Bressler, Mohammad Jangda, Automattic, and
 * others
 * Copyright (c) 2009-2019 Mohammad Jangda, Daniel Bachhuber, et al.
 * ------------------------------------------------------------------------------
 */
var __ = wp.i18n.__;
var PluginPostStatusInfo = wp.editPost.PluginPostStatusInfo;
var registerPlugin = wp.plugins.registerPlugin;
var _wp$data = wp.data,
    withSelect = _wp$data.withSelect,
    withDispatch = _wp$data.withDispatch;
var compose = wp.compose.compose;
var SelectControl = wp.components.SelectControl;
/**
 * Map Custom Statuses as options for SelectControl
 */

if (!jQuery.isFunction('$')) {
  //var $ = window.jQuery = jQuery;
}

var privacyStatusesSub = window.PPCustomPrivacySub.statuses.map(function (s) {
  return {
    label: s.name,
    value: s.slug
  };
});

var getPrivacyLabelSub = function getPrivacyLabelSub(slug) {
  var item = privacyStatusesSub.find(function (s) {
    return s.value === slug;
  });

  if (item) {
    return item.label;
  }

  return '';
}; // return label only for published / private statuses

jQuery(document).ready(function ($) {

$(document).on('click', 'button.editor-post-publish-button', function() {
  var publishIntervalSub = setInterval(function() {
    if (wp.data.select('core/editor').isSavingPost()) {

      var publishCompleteIntervalSub = setInterval(function() {
        if (!wp.data.select('core/editor').isSavingPost()) {
          clearInterval(publishCompleteIntervalSub);

          var storedStatus = wp.data.select('core/editor').getCurrentPostAttribute('status');
          var status = wp.data.select('core/editor').getEditedPostAttribute('status');
          wp.data.dispatch('core/editor').editPost({status: 'draft'});
          wp.data.dispatch('core/editor').editPost({status: storedStatus});

          wp.data.dispatch('core/editor').refreshPost();

          storedStatus = wp.data.select('core/editor').getCurrentPostAttribute('status');
          status = wp.data.select('core/editor').getEditedPostAttribute('status');
          wp.data.dispatch('core/editor').editPost({status: 'draft'});
          wp.data.dispatch('core/editor').editPost({status: storedStatus});
        }
      }, 500);

      clearInterval(publishIntervalSub);
    }
  }, 10);
});

}); // jQuery

/**
 * Custom status component
 * @param object props
 */
var PPCustomSubPostPrivacyInfo = function PPCustomSubPostPrivacyInfo(_ref) {
  var onUpdate = _ref.onUpdate;
  
  if (_ref.pp_subpost_visibility === null) {
    var pp_subpost_visibility = '';
  } else {
    var pp_subpost_visibility = _ref.pp_subpost_visibility;
  }

  let listStatuses = privacyStatusesSub;

  var force = wp.data.select('core/editor').getCurrentPostAttribute('pp_inherited_subpost_visibility');
  
  if (force) {
    listStatuses = [];
    var i=0;
    $(privacyStatusesSub).each(function(s){
      if (-1 !== [force, 'draft'].indexOf(this.value)) {
        listStatuses[i]=this;
        i = i +1;
      }
    });
  }

  return React.createElement(PluginPostStatusInfo, {
    className: "publishpress-extended-subpost-privacy publishpress-extended-subpost-privacy-".concat(pp_subpost_visibility)
  }, 
  React.createElement("h4", null, window.PPCustomPrivacySub.caption), React.createElement(SelectControl, {
    label: "",
    value: pp_subpost_visibility,
    options: listStatuses,
    onChange: onUpdate
  }), 
  React.createElement("small", {
    className: "publishpress-extended-subpost-privacy-note"
  }, force ? __('Page descendent visibility is locked by parent page setting.','presspermit-pro'): ''));
};

var plugin = compose(withSelect(function (select) {
  return {
    pp_subpost_visibility: select('core/editor').getEditedPostAttribute('pp_subpost_visibility')
  };
}), withDispatch(function (dispatch) {
  return {
    onUpdate: function onUpdate(pp_subpost_visibility) {
      dispatch('core/editor').editPost({
        pp_subpost_visibility: pp_subpost_visibility
      });
    }
  };
}))(PPCustomSubPostPrivacyInfo);
registerPlugin('publishpress-custom-privacy-sub-block', {
  icon: 'admin-site',
  render: plugin
});