"use strict";

/**
 * ------------------------------------------------------------------------------
 * Based on Edit Flow
 * Author: Daniel Bachhuber, Scott Bressler, Mohammad Jangda, Automattic, and
 * others
 * Copyright (c) 2009-2019 Mohammad Jangda, Daniel Bachhuber, et al.
 * ------------------------------------------------------------------------------
 */

var rvycs__ = wp.i18n.__;

var PluginPostStatusInfo = wp.editPost.PluginPostStatusInfo;
var registerPlugin = wp.plugins.registerPlugin;
var _wp$data = wp.data,
    withSelect = _wp$data.withSelect,
    withDispatch = _wp$data.withDispatch;
var compose = wp.compose.compose;
var SelectControl = wp.components.SelectControl;
/**
 * Map Custom Statuses as options for SelectControl
 */

if (!jQuery.isFunction('$')) {
  var $ = window.jQuery = jQuery;
}

var statuses = window.PPCustomStatuses.statuses.map(function (s) {
  return {
    label: s.name,
    value: s.slug
  };
});

var getStatusLabel = function getStatusLabel(slug) {
  var item = statuses.find(function (s) {
    return s.value === slug;
  });

  if (item) {
    return item.label;
  }

  if (typeof privacyStatuses !== 'undefined') {
    item = privacyStatuses.find(function (s) {
      return s.value === slug;
    });

    if (item) {
      return item.label;
    }
  }

  return '';
}; // Remove the Published status from the list.


statuses = statuses.filter(function (item) {
  return item.value !== 'publish';
});

var ppcsOrigSaveDraftWidth = 0;
var ppcsSaveDraftLinkColor = false;

/**
 * Hack :(
 *
 * @see https://github.com/WordPress/gutenberg/issues/3144
 *
 * @param status
 */
var sideEffectL10nManipulation = function sideEffectL10nManipulation(status) {
  var statusLabel = getStatusLabel(status);

  if ('future' == status ) {
    return;
  }

  if (wp.data.select('core/editor').isSavingPost() || $('span.editor-post-saved-state:visible').length) {
    $('#ppcs_save_draft_label').hide();
    return;
  }

  //setTimeout(function () {
    var node = document.querySelector('.editor-post-save-draft');

    if (!node) {
      node = document.querySelector('.editor-post-switch-to-draft');
    }

    if (node) {
      if (statusLabel && ('publish' != status)) {
        var useButton = $('button.editor-post-save-draft').length ? 'button.editor-post-save-draft' : 'button.editor-post-switch-to-draft';

        if('draft' == status) { //} && -1 !== PPCustomStatuses.publishedStatuses.indexOf(wp.data.select('core/editor').getCurrentPostAttribute('status'))) {
            $('#ppcs_save_draft_label').hide();

            if (ppcsOrigSaveDraftWidth) {
              $(useButton).css('width', ppcsOrigSaveDraftWidth).css('padding-right', '80px');
            }

            if (ppcsSaveDraftLinkColor !== false) {
              $('button.editor-post-save-draft, button.editor-post-switch-to-draft').css('color', ppcsSaveDraftLinkColor).css('white-space', 'nowrap');
            }

            if ('button.editor-post-switch-to-draft' == useButton) {
              $('div.publishpress-extended-post-status select option[value!="draft"]').attr('disabled', true);
              
            } else {
              $('div.publishpress-extended-post-status select option[value!="draft"]').removeAttr('disabled');
            }

        } else {
          if (-1 === PPCustomStatuses.publishedStatuses.indexOf(status)) {
            if ($(useButton).filter(':visible').length && (document.querySelector(useButton).innerText || document.querySelector(useButton).innerText)) {
              var setColor = $('.edit-post-header').css('background');
              if (!setColor || (setColor.indexOf(' ') != -1) || (setColor.indexOf('.') != -1)) {
                setColor = '#fff';
              }
              
              if (ppcsSaveDraftLinkColor === false) {
                ppcsSaveDraftLinkColor = $('button.editor-post-save-draft, button.editor-post-switch-to-draft').css('color');

                if ((setColor === ppcsSaveDraftLinkColor) || !ppcsSaveDraftLinkColor) {
                  ppcsSaveDraftLinkColor = '#007cba';
                }
              }

              $('button.editor-post-save-draft, button.editor-post-switch-to-draft').css('color', setColor);

              if (!$('#ppcs_save_draft_label').length) {
                $(useButton).after('<span id="ppcs_save_draft_label"></span>');
                $('#ppcs_save_draft_label').css('color', ppcsSaveDraftLinkColor).css('position', 'absolute').css('pointer-events', 'none');
              }
            }

            $('#ppcs_save_draft_label').show();
          }
        }

        if ($('#ppcs_save_draft_label').filter(':visible').length) {
          if (!ppcsOrigSaveDraftWidth) {
            ppcsOrigSaveDraftWidth = $('button.editor-post-save-draft').width();
          }

          statusLabel = rvycs__('Save as %s').replace('%s', statusLabel);

          var buttonWidth = 18 + parseInt(statusLabel.length) * 6.5;
          
          if (buttonWidth < ppcsOrigSaveDraftWidth) {
            buttonWidth = ppcsOrigSaveDraftWidth;
          }

          var newPadding = 12 + (buttonWidth - ppcsOrigSaveDraftWidth);

          $(useButton).css('width', buttonWidth).css('padding-right', newPadding.toString() + 'px');

          var spanPosLeft = $(useButton).position().left + 10; // + (buttonWidth - ppcsOrigSaveDraftWidth);
          $('#ppcs_save_draft_label').html(statusLabel).css('left', spanPosLeft + 'px');
        }
      }
    }
  //}, 100);

  //var storedStatus = wp.data.select('core/editor').getCurrentPostAttribute('status');

  //if (('publish' != status) && (-1 == PPCustomStatuses.publishedStatuses.indexOf(status)) && (-1 == PPCustomStatuses.publishedStatuses.indexOf(storedStatus) || $('div.publishpress-extended-post-status').hasClass('pp-saving-draft'))) {
  if (('publish' != status) && (-1 == PPCustomStatuses.publishedStatuses.indexOf(status))) {
    $('div.publishpress-extended-post-status select').show();
    $('div.publishpress-extended-post-status-published').hide();
    $('div.publishpress-extended-post-status select option[value="publish"]').hide();

  } else {
    $('div.publishpress-extended-post-status select').hide();

    if (!$('div.publishpress-extended-post-status-published').length) {
      $('div.publishpress-extended-post-status select').after('<div class="publishpress-extended-post-status-published" style="display:none;text-align:right;padding-right:5px">' + rvycs__('Published') + '</div>');
    }

    $('div.publishpress-extended-post-status-published').show();
  }

  if (!$('.publishpress-extended-post-status-note').length) {
    $('.publishpress-extended-post-status select').after('<small class="publishpress-extended-post-status-note" style="display:none"></small>');
  }

  if (-1 == PPCustomStatuses.publishedStatuses.indexOf(status)) {
    $('div.publishpress-extended-post-status-note').html('').show();
  } else {
    $('div.publishpress-extended-post-status-note').html(rvycs__('To select a workflow status, switch to Draft first.', 'presspermit-pro')).show();
  }
};

/**
 * Hack :(
 * We need an interval because the DOM element is removed by autosave and rendered back after finishing.
 *
 * @see https://github.com/WordPress/gutenberg/issues/3144
 */
setInterval(function () {
  var status = wp.data.select('core/editor').getEditedPostAttribute('status');

  if ('future' == status ) {
    return;
  }
    
  jQuery(document).ready(function ($) {
    if (! $('div.publishpress-extended-post-status:visible').length) {
      return;
    }

    sideEffectL10nManipulation(status);
  });

  //if (-1 !== PPCustomStatuses.publishedStatuses.indexOf(status)) {
  //  return;
  //}
}, 250);

/**
 * Custom status component
 * @param object props
 */
var PPCustomPostStatusInfo = function PPCustomPostStatusInfo(_ref) {
  var onUpdate = _ref.onUpdate,
      status = _ref.status;

  var storedStatus = wp.data.select('core/editor').getCurrentPostAttribute('status');
  
  var statusOptions = statuses.slice();

  var rvy__ = wp.i18n.__;

  var getStatusOptionLabel = function getStatusOptionLabel(slug) {
    var item = statusOptions.find(function (s) {
      return s.value === slug;
    });

    if (item) {
      return item.label;
    }
  
    return '';
  };

  if (!getStatusOptionLabel(storedStatus) && -1 !== PPCustomStatuses.publishedStatuses.indexOf(storedStatus)) {
    var currentStatus = {label:rvycs__('(Published)'), value: storedStatus};
    statusOptions.unshift(currentStatus);
  }

  return React.createElement(PluginPostStatusInfo, {
    className: "publishpress-extended-post-status publishpress-extended-post-status-".concat(status)
  }, React.createElement("h4", null, rvycs__('Post Status', 'presspermit-pro')), React.createElement(SelectControl, {
    label: "",
    value: status,
    options: statusOptions,
    onChange: onUpdate
  }),

  React.createElement("small", {
    className: "publishpress-extended-post-status-note"
  }, rvy__("Legacy mode: PublishPress Statuses not active.", 'presspermit-pro'))
  );
};

var plugin = compose(withSelect(function (select) {
  return {
    status: select('core/editor').getEditedPostAttribute('status')
  };
}), withDispatch(function (dispatch) {
  return {
    onUpdate: function onUpdate(status) {
      dispatch('core/editor').editPost({
        status: status
      });
      sideEffectL10nManipulation(status);
    }
  };
}))(PPCustomPostStatusInfo);
registerPlugin('publishpress-custom-status-block', {
  icon: 'admin-site',
  render: plugin
});