"use strict";

/**
 * ------------------------------------------------------------------------------
 * Based on Edit Flow
 * Author: Daniel Bachhuber, Scott Bressler, Mohammad Jangda, Automattic, and
 * others
 * Copyright (c) 2009-2019 Mohammad Jangda, Daniel Bachhuber, et al.
 * ------------------------------------------------------------------------------
 */

var rvy__ = wp.i18n.__;

var PluginPostStatusInfo = wp.editPost.PluginPostStatusInfo;
var registerPlugin = wp.plugins.registerPlugin;
var _wp$data = wp.data,
    withSelect = _wp$data.withSelect,
    withDispatch = _wp$data.withDispatch;
var compose = wp.compose.compose;
var SelectControl = wp.components.SelectControl;

/**
 * Map Custom Statuses as options for SelectControl
 */

if (!jQuery.isFunction('$')) {
  //var $ = window.jQuery = jQuery;
}

var privacyStatuses = window.PPCustomPrivacy.statuses.map(function (s) {
  return {
    label: s.label,
    value: s.name
  };
});

var getPrivacyLabel = function getPrivacyLabel(slug) {
  var item = privacyStatuses.find(function (s) {
    return s.value === slug;
  });

  if (item) {
    return item.label;
  }

  return '';
}; // return label only for published / private statuses


/**
 * Hack :(
 *
 * @see https://github.com/WordPress/gutenberg/issues/3144
 *
 * @param status
 */

jQuery(document).ready(function ($) {

var origSaveDraftWidth = 0;
var saveDraftLinkColor = false;

var sideEffectL10nPrivacyManipulation = function sideEffectL10nPrivacyManipulation(status) {
  setTimeout(function () {
    var privacyLabel = getPrivacyLabel(status);
    var node = document.querySelector('.editor-post-save-draft');
    var storedStatus = wp.data.select('core/editor').getCurrentPostAttribute('status');

    if (wp.data.select('core/editor').isSavingPost() || $('span.editor-post-saved-state:visible').length) {
      $('#pp_save_draft_label').hide();

      if ($('div.publishpress-extended-post-privacy select:visible').length) {
        $('div.publishpress-extended-post-privacy select').focus();
      }

      return;
    }

    var selectedVisibility = $('div.publishpress-extended-post-privacy select').val();

    if (selectedVisibility && 'draft' == selectedVisibility) {
      $('div.publishpress-extended-post-privacy').hide();

    } else {
      $('div.publishpress-extended-post-privacy').show();
    }

    if (privacyLabel) {
      if ($('button.editor-post-save-draft:visible').length) {
        $('#pp_save_draft_label').toggle(['publish', 'future', 'draft'].indexOf(status) === -1);
      }

      $('.editor-post-publish-button').toggle(((['publish', 'private', 'future'].indexOf(storedStatus) !== -1) || ['publish', 'draft'].indexOf(status) !== -1) 
      && (status != 'draft' || ($('button.editor-post-switch-to-draft').length > 0)));
    }

    if (!node) {
      node = document.querySelector('.editor-post-switch-to-draft');
    }

    var setColor;

      if (!$('input.editor-post-visibility__dialog-radio[value="password"]').prop('checked')) {
        if (PPCustomPrivacy.forceVisibility) {
          if ('publish' == PPCustomPrivacy.forceVisibility) {
            $('input.editor-post-visibility__dialog-radio[value="private"]').prop('disabled','disabled');
            $('input.editor-post-visibility__dialog-radio[value="public"]').prop('disabled',false);
          } else {
            $('input.editor-post-visibility__dialog-radio[value="private"]').prop('disabled',false);
            $('input.editor-post-visibility__dialog-radio[value="public"]').prop('disabled','disabled');
          }
        } else {
          if ('draft' == status) {
            $('button.edit-post-post-visibility__toggle').html(rvy__('Public'));
            $('input.editor-post-visibility__dialog-radio[value="public"]').prop('disabled', false);
            $('input.editor-post-visibility__dialog-radio[value="public"]').prop('checked','checked');
          }

          if (('future' != status ) && window.PPCustomPrivacy.defaultPrivacy && getPrivacyLabel(window.PPCustomPrivacy.defaultPrivacy) && (! getPrivacyLabel(storedStatus) || 'draft' == storedStatus )) {
            $('input.editor-post-visibility__dialog-radio[value="private"]').prop('checked','checked');
            $('input.editor-post-visibility__dialog-radio[value="public"]').prop('disabled','disabled');
            $('button.edit-post-post-visibility__toggle').html(getPrivacyLabel(window.PPCustomPrivacy.defaultPrivacy));
          }
        }

        if (privacyLabel && ['publish', 'private', 'future', 'draft'].indexOf(status) === -1) {
          $('input.editor-post-visibility__dialog-radio[value="public"]').prop('disabled',true);

          setColor = $('.edit-post-header').css('background');
          if (!setColor || (setColor.indexOf(' ') != -1) || (setColor.indexOf('.') != -1)) {
            setColor = '#fff';
          }

          if (saveDraftLinkColor === false) {
            saveDraftLinkColor = $('button.editor-post-save-draft').css('color');
            
            if ((setColor === saveDraftLinkColor) || !saveDraftLinkColor) {
              saveDraftLinkColor = '#007cba';
            }
          }

          $('span.presspermit-editor-toggle').hide();

        } else {
          $('input.editor-post-visibility__dialog-radio[value="public"]').prop('disabled','');
        }
      }

    if ('future'==status) {
      return;
    }
    

    if (node) {
      if (status !== 'draft') {
        if (status === 'publish') {
          if (!$('input.editor-post-visibility__dialog-radio[value="password"]').prop('checked')) {
            $('button.edit-post-post-visibility__toggle').html(rvy__('Public'));
            $('input.editor-post-visibility__dialog-radio[value="public"]').prop('checked','checked');
          }
        } else {
          if (privacyLabel) {
            $('button.edit-post-post-visibility__toggle').html(privacyLabel);
            $('input.editor-post-visibility__dialog-radio[value="private"]').prop('checked','checked');

            PPCS_RecaptionOnDisplay(rvy__('Save as %s').replace('%s', privacyLabel));
          }
        }

        if ('password' == wp.data.select('core/editor').getEditedPostVisibility() || ($('input.editor-post-visibility__dialog-password-input').length && $('input.editor-post-visibility__dialog-password-input').val())) {
          $('button.edit-post-post-visibility__toggle').html(rvy__('Password Protected'));
          $('input.editor-post-visibility__dialog-radio[value="password"]').prop('checked', 'checked');
          $('input.editor-post-visibility__dialog-radio[value="public"]').prop('disabled','');
        }
      }
    }

  }, 100);
};

// Disable custom visibility selection while post save is in progress
setInterval(function () {
  let hideVisSelector = wp.data.select('core/editor').isSavingPost();
  $('div.publishpress-extended-post-privacy select').prop('disabled', hideVisSelector);
}, 200);

/**
 * Hack :(
 * We need an interval because the DOM element is removed by autosave and rendered back after finishing.
 *
 * @see https://github.com/WordPress/gutenberg/issues/3144
 */
var ppStatusMainInterval = setInterval(function () {
  sideEffectL10nPrivacyManipulation(wp.data.select('core/editor').getEditedPostAttribute('status'));
}, 250);

$(document).on('click', 'button.editor-post-switch-to-draft', function() {
  clearInterval(ppStatusMainInterval);

  setTimeout(function() {
    ppStatusMainInterval = setInterval(function () {
      sideEffectL10nPrivacyManipulation(wp.data.select('core/editor').getEditedPostAttribute('status'));
    }, 250);
  }, 1000);
});

var HideButtonsInterval = '';

$(document).on('change', 'div.publishpress-extended-post-privacy select', function() {
  var setStatus = $('div.publishpress-extended-post-privacy select').val();
  var storedStatus = wp.data.select('core/editor').getCurrentPostAttribute('status');

  if ('password'==setStatus) {
    return;
  }

  if (wp.data.select('core/editor').isSavingPost()) {
    return;
  }

  clearInterval(HideButtonsInterval);

  if (['publish', 'draft', 'future'].indexOf(setStatus) === -1 || ('private'==setStatus && 'private' != storedStatus )) {
    $('#inspector-checkbox-control-1').attr('disabled','disabled');

    HideButtonsInterval = setInterval(function(){
      if (!wp.data.select('core/editor').isSavingPost()) {
        $('button.editor-post-publish-panel__toggle').hide();
      }
    }, 50);

  } else {
    clearInterval(HideButtonsInterval);
    $('button.editor-post-publish-panel__toggle').show();

    if ('draft'==setStatus) {
      $('#inspector-checkbox-control-1').removeAttr('disabled');
    }
  }

  var selector = 'div.publishpress-extended-post-privacy select, button.editor-post-save-draft, .editor-post-save-draft, .editor-post-switch-to-draft';

  if (storedStatus != setStatus ) {
    $(selector).attr('disabled', 'disabled');

    var intDisableSave = setInterval(function(){
      $(selector).attr('disabled', 'disabled');
    }, 50);

    var data = {
      'pp_ajax_set_privacy': setStatus,
      'post_id': wp.data.select('core/editor').getCurrentPostId()
    };

    $('button.editor-post-publish-button__button, button.editor-post-publish-panel__toggle').prop('disabled', true);

    $.post(window.PPCustomPrivacy.ajaxurl, data, function () {
      
      wp.data.dispatch('core/editor').editPost({status: storedStatus});
      wp.data.dispatch('core/editor').editPost({status: setStatus});
      
      wp.data.dispatch('core/editor').refreshPost();

      clearInterval(intDisableSave);
      $(selector).prop('disabled', false);

      setTimeout(function() {
        $('button.editor-post-publish-button__button, button.editor-post-publish-panel__toggle').prop('disabled', false);
      }, 1000);

      setTimeout(function(){
        sideEffectL10nPrivacyManipulation(setStatus);
      }, 500);
    });
  }
});


$(document).on('click', 'input.editor-post-visibility__dialog-radio[value="password"]', function() {
  if (!$('input.editor-post-visibility__dialog-password-input').val()) {
    setTimeout(function() {
      $('input.editor-post-visibility__dialog-password-input').val(rvy__('(enter password)')).select();
    }, 500);
  }
});


$(document).on('click', 'input.editor-post-visibility__dialog-radio[value="private"]', function() {
  setTimeout(function() {
    $('div.edit-post-post-visibility__dialog').hide();
  }, 500);
});

if (window.PPCustomPrivacy.defaultPrivacy) {
  var intDefaultPrivacy = setInterval(function() {
    if ($('button.edit-post-post-visibility__toggle').filter(':visible').length) {
      $('button.edit-post-post-visibility__toggle').html(getPrivacyLabel(window.PPCustomPrivacy.defaultPrivacy));
      	clearInterval(intDefaultPrivacy);
    }
  }, 50);
}

}); // jQuery ready


/**
 * Custom status component
 * @param object props
 */
var PPCustomPostPrivacyInfo = function PPCustomPostPrivacyInfo(_ref) {
  var onUpdate = _ref.onUpdate,
      status = _ref.status;

  let listStatuses = privacyStatuses;

  var force = wp.data.select('core/editor').getCurrentPostAttribute('pp_force_visibility');
  var forceDefault;

  if (!jQuery.isFunction('$')) {
    var $ = window.jQuery = jQuery;
  }

  if ('draft' == status) {
    $('#pp_save_draft_label').hide();
  }

  if (!force && PPCustomPrivacy.forceVisibility) {
      force = PPCustomPrivacy.forceVisibility;
      forceDefault = true;
  }

  if (force) {
    listStatuses = [];
    var i=0;

    privacyStatuses.forEach(function(item) {
      if (-1 !== [force, 'draft'].indexOf(item.value)) {
        listStatuses[i]=item;
        i = i +1;
      }
    });
  }

  var storedStatus = wp.data.select('core/editor').getCurrentPostAttribute('status');

  if (PPCustomPrivacy.customPrivacyEnabled) {
    return React.createElement(PluginPostStatusInfo, {
      className: "publishpress-extended-post-privacy publishpress-extended-post-privacy-".concat(status)
    }, 
    React.createElement("h4", null, rvy__('Visibility', 'presspermit-pro')), 
    getPrivacyLabel(status) ? React.createElement(SelectControl, {
      label: "",
      value: status,
      options: listStatuses,
      onChange: onUpdate
    }) : '', 
    React.createElement("small", {
      className: "publishpress-extended-post-privacy-note"
    }, forceDefault ? rvy__('Visibility is locked by default settings.', 'presspermit-pro') : force ? rvy__('Visibility is locked by parent page setting.','presspermit-pro'): getPrivacyLabel(status) && -1 == ['draft'].indexOf(status) ? '' : rvy__('To select a custom visibility, first privately publish the post.')));
  }
};

if (PPCustomPrivacy.customPrivacyEnabled) {
  var plugin = compose(withSelect(function (select) {
    return {
      status: select('core/editor').getEditedPostAttribute('status')
    };
  }), withDispatch(function (dispatch) {
    return {
      onUpdate: function onUpdate(status) {
        dispatch('core/editor').editPost({
          status: status
        });
      }
    };
  }))(PPCustomPostPrivacyInfo);
  registerPlugin('publishpress-custom-privacy-block', {
    icon: 'admin-site',
    render: plugin
  });
}