# Contributing
Hey, that's awesome! Thanks for your interest and for taking the time to contribute.
The following is a set of guidelines for contributing to PublishPress Future Pro plugin. Use your best judgment, and feel free to propose changes to this document in a pull request.

## How can I contribute?

### Reporting Bugs

A bug is a demonstrable problem caused by code in the repository.

Before creating bug reports, please check our [bug list](https://github.com/publishpress/PublishPress-Future/issues?utf8=✓&q=is%3Aissue+is%3Aopen+), as the bug might be already be known.

**Note:** If you find a **closed** issue that seems the same as the one you're experiencing, check if you have the most recent release. If you have, please open a new issue including a link to the original one in its body.

#### How do I submit a good bug report?

- Use a **clear and descriptive title**
- Describe the exact steps which reproduce the problem **in as many details as possible**, ie OS, browser, required plugins, PHP or WordPress versions
- Describe the **observed behavior** when following the steps, pointing out **why it's a problem**
- Describe the **expected behavior** and **why it was expected**
- If possible, include screenshots/media showing the described steps and clearly demonstrating the problem

### Suggesting Enhancements

Enhancements can be minor improvements to existing functionality or even completely new features.

Before creating enhancement suggestions, please check our [issues list](https://github.com/publishpress/PublishPress-Future/issues), as the enhancement might be already known.

#### How do I submit a good enhancement suggestion?

- Use a **clear and descriptive title**
- Provide as many details as possible in a **step-by-step description** of the suggested enhancement
- Provide **examples** to demonstrate the steps
- Describe the **expected behavior**
- Describe the **current behavior**
- Explain **why this enhancement would be useful** to you and other PublishPress Authors users

### Submitting Pull Requests

#### How do I submit a good pull request?

- Fork the repository (do not submit your own branches to this repo)
- Create a **new branch for each issue** you are trying to solve. Make sure it starts off our `development` branch and is updated
- Create **a pull request for each problem** you are fixing. You can mention multiple issues, but they have to be related somehow. Different problems have to be fixed on different pull requests
- **Do not submit to the master branch**. Always submit pull requests to the `development` or other branch
- Fill in the [required template](https://github.com/publishpress/PublishPress-Future-Pro/blob/development/.github/PULL_REQUEST_TEMPLATE.md)
