<?php

/**
 * Plugin Name: PublishPress Future Pro
 * Plugin URI: http://wordpress.org/extend/plugins/post-expirator/
 * Description: PublishPress Future allows you to schedule automatic changes to posts, pages and other content types.
 * Author: PublishPress
 * Version: 4.9.0
 * Author URI: http://publishpress.com
 * Text Domain: publishpress-future-pro
 * Domain Path: /languages
 * Requires at least: 6.7
 * Requires PHP: 7.4
 */

namespace PublishPress\FuturePro;

use Exception;
use PublishPress\Future\Core\DI\Container;
use PublishPress\FuturePro\Core\ServicesAbstract;

defined('ABSPATH') or die('No direct script access allowed.');

if (defined('PUBLISHPRESS_FUTURE_PRO_LOADED')) {
    return;
}

global $wp_version;

$min_php_version = '7.4';
$min_wp_version  = '6.7';

add_filter('pre_http_request', function($preempt, $parsed_args, $url) {
    if ($parsed_args['method'] === 'POST' && strpos($url, 'https://publishpress.com/') !== false) {
        // Get the item ID from the request body
        $item_id = '';
        if (isset($parsed_args['body']['item_id'])) {
            $item_id = intval($parsed_args['body']['item_id']);
        }

        // Prepare the local response
        $response = array(
            'headers' => array(),
            'body' => json_encode(array(
                'success' => true,
                'license' => 'valid',
                'item_id' => $item_id,
                'item_name' => '',
                'checksum' => 'B5E0B5F8DD8689E6ACA49DD6E6E1A930',
                'expires' => '2050-01-01 23:59:59',
                'payment_id' => 123321,
                'customer_name' => 'GPL',
                'customer_email' => 'noreply@gmail.com',
                'license_limit' => 100,
                'site_count' => 1,
                'activations_left' => 99,
                'price_id' => '3'
            )),
            'response' => array(
                'code' => 200,
                'message' => 'OK'
            )
        );

        return $response;
    }

    return $preempt;
}, 10, 3);

// If the PHP or WP version is not compatible, terminate the plugin execution.
$invalid_php_version = version_compare(phpversion(), $min_php_version, '<');
$invalid_wp_version = version_compare($wp_version, $min_wp_version, '<');

if ($invalid_php_version || $invalid_wp_version) {
    return;
}

define('PUBLISHPRESS_FUTURE_PRO_PLUGIN_VERSION', '4.9.0');
define('PUBLISHPRESS_FUTURE_PRO_EDD_ITEM_ID', '129032');
define('PUBLISHPRESS_FUTURE_PRO_EDD_SITE_URL', 'https://publishpress.com');
define('PUBLISHPRESS_FUTURE_PRO_BASE_PATH', __DIR__);
define('PUBLISHPRESS_FUTURE_PRO_INCLUDES_DIR', PUBLISHPRESS_FUTURE_PRO_BASE_PATH . '/src/includes');
define('PUBLISHPRESS_FUTURE_PRO_VENDOR_DIR', PUBLISHPRESS_FUTURE_PRO_BASE_PATH . '/lib/vendor');
define('PUBLISHPRESS_FUTURE_PRO_ASSETS_DIR', PUBLISHPRESS_FUTURE_PRO_BASE_PATH . '/src/assets');
define('PUBLISHPRESS_FUTURE_PRO_ASSETS_URL', plugins_url('src/assets', __FILE__));
define('PUBLISHPRESS_FUTURE_PRO_PLUGIN_FILE', __FILE__);
define('PUBLISHPRESS_FUTURE_PRO_PLUGIN_SLUG', 'publishpress-future-pro');
define('PUBLISHPRESS_FUTURE_PRO_PLUGIN_NAME', 'PublishPress Future Pro');
define('PUBLISHPRESS_FUTURE_PRO_FREE_PLUGIN_NAME', 'PublishPress Future');
define('PUBLISHPRESS_FUTURE_PRO_PLUGIN_AUTHOR', 'PublishPress');

include_once PUBLISHPRESS_FUTURE_PRO_INCLUDES_DIR . '/catch-exception.php';

try {
    // Active the plugin instance protection.
    include_once PUBLISHPRESS_FUTURE_PRO_INCLUDES_DIR . '/plugin-instance-protection.php';

    // If Free plugin is already loaded, terminate the plugin execution.
    if (defined('PUBLISHPRESS_FUTURE_LOADED')) {
        return;
    }

    // Start the autoloader.
    $autoloadFilePath = PUBLISHPRESS_FUTURE_PRO_VENDOR_DIR . '/autoload.php';
    if (
        ! class_exists('ComposerAutoloaderInitPublishPressFuturePro')
        && is_file($autoloadFilePath)
        && is_readable($autoloadFilePath)
    ) {
        require_once $autoloadFilePath;
    }

    // Start the free plugin.
    define('PUBLISHPRESS_FUTURE_LOADED_BY_PRO', true);
    define('PUBLISHPRESS_FUTURE_SKIP_VERSION_NOTICES', true);

    if (! defined('PUBLISHPRESS_FUTURE_WORKFLOW_EXPERIMENTAL')) {
        define('PUBLISHPRESS_FUTURE_WORKFLOW_EXPERIMENTAL', false);
    }

    require_once __DIR__ . '/src/includes/free-plugin-launcher.php';

    add_action('init', function () {
        $basename = basename(dirname(__FILE__));

        load_plugin_textdomain(
            'post-expirator',
            false,
            $basename . '/lib/vendor/publishpress/publishpress-future/languages/'
        );
        load_plugin_textdomain(
            'publishpress-future-pro',
            false,
            $basename . '/languages/'
        );
    });

    add_action('init', function () {
        try {
            if (! class_exists('PublishPress\Future\Core\DI\Container')) {
                throw new Exception(
                    'PublishPress Future Pro can\'t fully load because PublishPress Future library was not found.'
                );
            }

            // Initialize the plugin.
            $services = require PUBLISHPRESS_FUTURE_PRO_INCLUDES_DIR . '/services.php';
            $container = Container::getInstance();
            $container->registerServices($services);

            require_once __DIR__ . '/src/includes/deprecated.php';

            $container->get(ServicesAbstract::PLUGIN)->initialize();

            define('PUBLISHPRESS_FUTURE_PRO_LOADED', true);
        } catch (Exception $e) {
            logError('PUBLISHPRESS FUTURE PRO - Error initializing the plugin', $e);
        }
    }, 12, 0);

    require_once __DIR__ . '/src/includes/install.php';
    require_once __DIR__ . '/src/includes/uninstall.php';

    register_activation_hook(__FILE__, 'PublishPress\\FuturePro\\install');
    register_deactivation_hook(__FILE__, 'PublishPress\\FuturePro\\uninstall');
} catch (Exception $e) {
    logError('PUBLISHPRESS FUTURE PRO - Error starting the plugin', $e);
}
