<?php

namespace PublishPress\FuturePro\Modules\Notifications\Migrations;

use PublishPress\Future\Core\HookableInterface;
use PublishPress\Future\Modules\Expirator\HooksAbstract as ExpiratorHooks;
use PublishPress\Future\Framework\Database\Interfaces\DBTableSchemaInterface;
use PublishPress\Future\Modules\Expirator\Interfaces\MigrationInterface;
use PublishPress\FuturePro\Modules\Notifications\HooksAbstract;

defined('ABSPATH') or die('Direct access not allowed.');

class V040600NotificationsSchema implements MigrationInterface
{
    public const HOOK = HooksAbstract::ACTION_MIGRATE_V040600_ON_NOTIFICATIONS;

    private $hooksFacade;

    /**
     * @var DBTableSchemaInterface
     */
    private $tableSchema;

    /**
     * @param \PublishPress\Future\Core\HookableInterface $hooksFacade
     */
    public function __construct(
        HookableInterface $hooksFacade,
        DBTableSchemaInterface $tableSchema
    ) {
        $this->hooksFacade = $hooksFacade;
        $this->tableSchema = $tableSchema;

        $this->hooksFacade->addAction(self::HOOK, [$this, 'migrate']);
        $this->hooksFacade->addAction(
            ExpiratorHooks::FILTER_ACTION_SCHEDULER_LIST_COLUMN_HOOK,
            [$this, 'formatLogActionColumn'],
            10,
            2
        );
    }

    public function migrate()
    {
        if (!$this->tableSchema->isTableHealthy()) {
            $this->tableSchema->fixTable();
        }
    }

    /**
     * @param string $text
     * @param array $row
     * @return string
     */
    public function formatLogActionColumn($text, $row)
    {
        if ($row['hook'] === self::HOOK) {
            return __('Migrate notifications schema after v4.6.0', 'publishpress-future-pro');
        }

        return $text;
    }
}
