<?php

namespace PublishPress\FuturePro\Modules\Notifications\Models;

class NotificationUserModel
{
    private const NOTIFICATIONS_USER_META_KEY = 'publishpress_future_last_notification_time';

    /**
     * Get the last notification time for a specific user
     *
     * @param int|null $userId The user ID. If null, uses the current user.
     * @return int The timestamp of the last notification
     * @since 4.6.0
     */
    public function getLastNotificationTime(?int $userId = null): int
    {
        if ($userId === null) {
            $userId = get_current_user_id();
        }

        return (int) get_user_meta(
            $userId,
            self::NOTIFICATIONS_USER_META_KEY,
            true
        );
    }

    /**
     * Set the last notification time for a specific user
     *
     * @param int|null $userId The user ID. If null, uses the current user.
     * @return bool Whether the update was successful
     * @since 4.6.0
     */
    public function setLastNotificationTime(?int $userId = null): bool
    {
        if ($userId === null) {
            $userId = get_current_user_id();
        }

        return (bool) update_user_meta(
            $userId,
            self::NOTIFICATIONS_USER_META_KEY,
            time()
        );
    }
}
