<?php

namespace PublishPress\FuturePro\Modules\Workflows\Domain\Steps\Actions\Runners;

use PublishPress\Future\Modules\Workflows\Domain\Steps\Actions\Definitions\SendInSiteNotification;
use PublishPress\Future\Modules\Workflows\Interfaces\StepRunnerInterface;
use PublishPress\FuturePro\Modules\Workflows\Interfaces\InSiteNotificationdProcessorInterface;

class SendInSiteNotificationRunner implements StepRunnerInterface
{
    /**
     * @var InSiteNotificationdProcessorInterface
     */
    private $stepProcessor;

    public function __construct(
        InSiteNotificationdProcessorInterface $stepProcessor
    ) {
        $this->stepProcessor = $stepProcessor;

        $this->stepProcessor->setBranchRouting([
            'dismiss' => 'read',
        ]);
    }

    public static function getNodeTypeName(): string
    {
        return SendInSiteNotification::getNodeTypeName();
    }

    public function setup(array $step, array $contextVariables = []): void
    {
        $this->stepProcessor->setup($step, '__return_true');
        $this->stepProcessor->runNextSteps($step);
    }

    public function actionCallback(array $compactedArgs, array $originalArgs, bool $triggerCallbackIsRunning = false)
    {
        $this->stepProcessor->actionCallback($compactedArgs, $originalArgs, $triggerCallbackIsRunning);
    }
}
