<?php

namespace PublishPress\FuturePro\Modules\Workflows\Domain\Steps\Actions\Runners;

use PublishPress\Future\Core\HookableInterface;
use PublishPress\Future\Framework\Logger\LoggerInterface;
use PublishPress\Future\Modules\Workflows\Domain\Steps\Actions\Definitions\UserInteraction;
use PublishPress\Future\Modules\Workflows\Interfaces\StepRunnerInterface;
use PublishPress\Future\Modules\Workflows\Interfaces\StepProcessorInterface;
use PublishPress\Future\Modules\Workflows\Interfaces\InSiteNotificationdProcessorInterface;
use PublishPress\Future\Modules\Workflows\Interfaces\ExecutionContextInterface;
use PublishPress\FuturePro\Modules\Workflows\Interfaces\RecipientsModelInterface;

class UserInteractionRunner implements StepRunnerInterface
{
    /**
     * @var InSiteNotificationdProcessorInterface
     */
    private $stepProcessor;

    /**
     * @var ExecutionContextInterface
     */
    private $executionContext;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var HookableInterface
     */
    private $hooks;

    /**
     * @var string
     */
    private $stepSlug;

    /**
     * @var RecipientsModelInterface
     */
    private $recipientsModel;

    public function __construct(
        StepProcessorInterface $stepProcessor,
        ExecutionContextInterface $executionContext,
        LoggerInterface $logger,
        HookableInterface $hooks,
        RecipientsModelInterface $recipientsModel
    ) {
        $this->stepProcessor = $stepProcessor;
        $this->executionContext = $executionContext;
        $this->logger = $logger;
        $this->hooks = $hooks;
        $this->recipientsModel = $recipientsModel;
    }

    public static function getNodeTypeName(): string
    {
        return UserInteraction::getNodeTypeName();
    }

    public function setup(array $step): void
    {
        $this->stepProcessor->setRecipientSettingName('responders');
        $this->stepProcessor->setup($step, '__return_true');
    }

    public function actionCallback(array $compactedArgs, array $originalArgs, bool $triggerCallbackIsRunning = false)
    {
        $this->stepProcessor->actionCallback($compactedArgs, $originalArgs, $triggerCallbackIsRunning);
    }
}
