<?php

namespace PublishPress\FuturePro\Modules\Workflows\Interfaces;

interface EventDrivenActionModelInterface
{
    public function load(int $eventDrivenActionId): bool;

    public function loadFromRow(array $row): bool;

    public function create(): ?int;

    public function markAsRunning(): bool;

    public function markAsCompleted(): bool;

    public function markAsFailed(string $error = ''): bool;

    public function markAsCancelled(): bool;

    public function getLogs(): array;

    public function update(): bool;

    public function loaded(): bool;

    public function belongsToCurrentUser(): bool;
}
