<?php

namespace PublishPress\FuturePro\Modules\Workflows;

use PublishPress\Future\Core\HookableInterface;
use PublishPress\Future\Framework\InitializableInterface;
use PublishPress\Future\Framework\Logger\LoggerInterface;
use PublishPress\Future\Framework\WordPress\Facade\RequestFacade;
use PublishPress\Future\Framework\WordPress\Models\CurrentUserModel;
use PublishPress\Future\Modules\Workflows\Interfaces\WorkflowEngineInterface;

class Module implements InitializableInterface
{
    /**
     * @var HookableInterface
     */
    private $hooks;

    /**
     * @var WorkflowEngineInterface
     */
    private $workflowEngine;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var RequestFacade
     */
    private $request;

    /**
     * @var CurrentUserModel
     */
    private $currentUserModel;

    public function __construct(
        HookableInterface $hooksFacade,
        WorkflowEngineInterface $workflowEngine,
        LoggerInterface $logger,
        RequestFacade $request,
        \Closure $currentUserModelFactory
    ) {
        $this->hooks = $hooksFacade;
        $this->workflowEngine = $workflowEngine;
        $this->logger = $logger;
        $this->request = $request;
        $this->currentUserModel = $currentUserModelFactory();

        $this->initializeEngine();
    }

    public function initialize()
    {
        $this->initializeControllers();
    }

    private function initializeControllers()
    {
        $controllers = [
            new Controllers\WorkflowEditor($this->hooks),
            new Controllers\PostRowActionTrigger(
                $this->hooks,
                $this->logger,
                $this->request,
                $this->currentUserModel
            ),
            new Controllers\Notifications($this->hooks, $this->logger),
        ];

        foreach ($controllers as $controller) {
            $controller->initialize();
        }
    }

    private function initializeEngine()
    {
        $this->workflowEngine->start();
        $this->workflowEngine->runWorkflows();
    }
}
