<?php
/**
 * Keeps queries generated by the firing of an action.
 *
 * @package lucatume\WPBrowser\Iterators\Filters
 */

namespace lucatume\WPBrowser\Iterators\Filters;

use Iterator;

class ActionsQueriesFilter extends QueriesCallerBasedKeepingFilterIterator
{
    /**
     * ClassMethodQueriesFilter constructor.
     *
     * @param Iterator<array{0: string, 1: float, 2: string, 3: float, 4?: array<int|string,mixed>}> $iterator
     * @param string            $action   The action to filter queries by.
     */
    public function __construct(Iterator $iterator, $action)
    {
        parent::__construct($iterator);

        $this->needles = [
            "do_action('{$action}')"
        ];
    }
}
