<?php
namespace QuizPressCertificates;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Assets {
	public static function init() {
		$self = new self();
		add_filter( 'ablocks/assets/editor_scripts_data', array( $self, 'add_quizpress_certificate_default_image' ) );
		add_filter( 'quizpress/assets/backend_scripts_data', array( $self, 'add_scripts_data' ) );
	}

	public function add_quizpress_certificate_default_image( $script_data ) {
		$certificate_image_array = array(
			'landscape' => array(
				'cert_1' => QUIZPRESS_ASSETS_URI . 'images/certificate/certificate-1.png',
				'cert_2' => QUIZPRESS_ASSETS_URI . 'images/certificate/certificate-2.png',
				'cert_3' => QUIZPRESS_ASSETS_URI . 'images/certificate/certificate-3.png',
				'cert_4' => QUIZPRESS_ASSETS_URI . 'images/certificate/certificate-4.png',
				'cert_5' => QUIZPRESS_ASSETS_URI . 'images/certificate/certificate-5.png',
				'cert_6' => QUIZPRESS_ASSETS_URI . 'images/certificate/certificate-6.png',
				'cert_7' => QUIZPRESS_ASSETS_URI . 'images/certificate/certificate-7.png',
				'custom_image' => QUIZPRESS_ASSETS_URI . 'images/certificate/place-holder.png',
			),
			'protrait' => array(
				'cert_1' => QUIZPRESS_ASSETS_URI . 'images/certificate/protrait-1.png',
				'cert_2' => QUIZPRESS_ASSETS_URI . 'images/certificate/protrait-2.png',
				'cert_3' => QUIZPRESS_ASSETS_URI . 'images/certificate/protrait-3.png',
				'cert_4' => QUIZPRESS_ASSETS_URI . 'images/certificate/protrait-4.png',
				'cert_5' => QUIZPRESS_ASSETS_URI . 'images/certificate/protrait-5-5.png',
				'cert_6' => QUIZPRESS_ASSETS_URI . 'images/certificate/protrait-6-6.png',
				'cert_7' => QUIZPRESS_ASSETS_URI . 'images/certificate/protrait-7-7.png',
				'custom_image' => QUIZPRESS_ASSETS_URI . 'images/certificate/place-holder.png',
			),
		);
		if ( ! isset( $script_data['certificate_image'] ) ) {
			$script_data['certificate_image'] = $certificate_image_array;
		}
		return $script_data;
	}

	public function add_scripts_data( array $data ): array {
		return array_merge( $data, [
			'certificates' => [
				'fonts_downloaded' => (bool) get_option( 'quizpress_mpdf_fonts_downloaded', false ),
				'certificate_url' => esc_url( add_query_arg( array( 'source' => 'qp-certificate' ), get_the_permalink() ) ),
			],
		] );
	}
}
