<?php

namespace QuizPressCertificates;

use Academy\Mpdf\Tag\Font;
use QuizPress\Helper;
use QuizPress\Interfaces\AddonInterface;
use QuizPressCertificates\Ajax\FontDownloader;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Certificates implements AddonInterface {
    private $addon_name = 'certificates';

    private function __construct() {
        $this->define_constants();
        $this->init_addon();
    }

    public static function init() {
		static $instance = false;

		if ( ! $instance ) {
			$instance = new self();
		}

		return $instance;
	}

    public function define_constants() {
        /**
         * Defines CONSTANTS for Certificate Addon.
         */
        define( 'QUIZPRESS_CERTIFICATE_VERSION', '0.0.1' );
        define( 'QUIZPRESS_CERTIFICATE_ADDON_DIR_PATH', QUIZPRESS_ADDONS_DIR_PATH . 'certificates/' );
    }

    public function init_addon() {
        add_action( "quizpress/addons/activated_{$this->addon_name}", array( $this, 'addon_activation_hook' ) );
		// if disable then stop running addon
		if ( ! Helper::get_addon_active_status( $this->addon_name ) ) {
			return;
		}

        Database::init();
        if ( is_admin() ) {
			Admin::init();
		}
		Assets::init();
		Frontend::init();
		Api::init();
        Ajax::init();
    }

    public function addon_activation_hook() {
        Installer::init();
    }
}