<?php
namespace QuizPressCertificates;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Database {

	public static function init() {
		$self = new self();
		add_action( 'init', [ $self, 'create_qp_certificate_post_type' ], 9 );
	}

	public function create_qp_certificate_post_type() {
		$post_type = 'qp_certificate';

		register_post_type(
			$post_type,
			array(
				'labels' => array(
					'name'               => _x( 'Certificates', 'post type general name', 'quizpress' ),
					'singular_name'      => _x( 'Certificate', 'post type singular name', 'quizpress' ),
					'add_new'            => _x( 'Add New', 'post type add_new', 'quizpress' ),
					'add_new_item'       => __( 'Add New Certificate', 'quizpress' ),
					'edit_item'          => __( 'Edit Certificate', 'quizpress' ),
					'new_item'           => __( 'New Certificate', 'quizpress' ),
					'all_items'          => __( 'All Certificates', 'quizpress' ),
					'view_item'          => __( 'View Certificate', 'quizpress' ),
					'search_items'       => __( 'Search Certificates', 'quizpress' ),
					'not_found'          => __( 'No certificates found', 'quizpress' ),
					'not_found_in_trash' => __( 'No certificates found in Trash', 'quizpress' ),
					'menu_name'          => __( 'Certificates', 'quizpress' ),
				),
				'public'                => true,
				'publicly_queryable'    => true,
				'show_ui'               => true,
				'show_in_menu'          => false,
				'show_in_admin_bar'     => false,
				'show_in_nav_menus'     => false,
				'hierarchical'          => false,
				'has_archive'           => false,
				'rewrite'               => array( 'slug' => 'certificate' ),
				'query_var'             => true,
				'delete_with_user'      => false,
				'supports'              => array(
					'title',
					'editor',
					'author',
					'thumbnail',
					'excerpt',
					'custom-fields',
					'comments'
				),
				'show_in_rest'          => true,
				'rest_base'             => $post_type,
				'rest_namespace'        => QUIZPRESS_PLUGIN_SLUG . '/v1',
				'rest_controller_class' => RestController::class,
				'capability_type'       => 'post',
				'template'              => [ [ 'ablocks/academy-certificate' ] ],
				'template_lock' => 'all',
			)
		);
	}
}
