<?php
namespace QuizPressCertificates;

use WP_REST_Posts_Controller;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class RestController extends WP_REST_Posts_Controller {

	public function __construct() {
		parent::__construct( 'qp_certificate' );
	}

	/**
	 * Optional: Allow "status=any" and similar REST params
	 */
	public function get_collection_params() {
		$params = parent::get_collection_params();
		if ( isset( $params['status']['enum'] ) ) {
			$params['status']['enum'][] = 'any';
		}
		return $params;
	}

	/**
	 * Optional: Control who can view the collection
	 */
	public function get_items_permissions_check( $request ) {
		// Allow all logged-in users to view; restrict guests
		if ( is_user_logged_in() ) {
			return true;
		}
		return new \WP_Error(
			'rest_forbidden',
			__( 'You are not allowed to view certificates.', 'quizpress' ),
			[ 'status' => rest_authorization_required_code() ]
		);
	}
}
