<?php

namespace QuizPressWoocommerce;

use QuizPress\Helper;
use QuizPress\Interfaces\AddonInterface;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Woocommerce implements AddonInterface {

	private $addon_name = 'woocommerce';

	private function __construct() {
		$this->define_constants();
		$this->init_addon();
	}

	public static function init() {
		static $instance = false;

		if ( ! $instance ) {
			$instance = new self();
		}

		return $instance;
	}

	public function define_constants() {
		define( 'QUIZPRESS_WC_VERSION', '1.0.0' );
		define( 'QUIZPRESS_WC_ADDON_DIR_PATH', QUIZPRESS_ADDONS_DIR_PATH . 'woocommerce/' );
	}

	public function init_addon() {
		add_action( "quizpress/addons/activated_{$this->addon_name}", [ $this, 'addon_activation_hook' ] );

		// Stop here if addon is disabled
		if ( ! Helper::get_addon_active_status( $this->addon_name ) ) {
			return;
		}
		Integration::init();
	}

	public function addon_activation_hook() {
		
	}
}
