<?php

namespace QuizPress;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class Addons {
	public static function init() {
		$self = new self();
		/**
		 * @fs_ignore
		 */
		$self->addons_loader();
		// check requirement
		add_action( 'quizpress/before_active_addon', array( $self, 'check_addon_pre_active_requirement' ), 10, 2 );
	}

	private function addons_loader() {
		$Autoload = Autoload::get_instance();
		$addons = apply_filters( 'quizpress/addons/loader_args', [
			'certificates' => 'Certificates',
			'woocommerce'  => 'Woocommerce',
		] );
		foreach ( $addons as $addon_name => $addon_class_name ) {
			$addon_root_path = QUIZPRESS_ADDONS_DIR_PATH . $addon_name . '/';
			if ( ! is_dir( $addon_root_path ) ) {
				continue;
			}
			$addon_namespace = 'QuizPress' . $addon_class_name;
			$Autoload->add_namespace_directory(
				$addon_namespace,
				$addon_root_path
			);
			$class = $addon_namespace . '\\' . $addon_class_name;
			if ( ! class_exists( $class ) || ! method_exists( $class, 'init' ) ) {
				continue;
			}
			$class::init();
		}
	}


	public function check_addon_pre_active_requirement( $addon_slug, $requirement ) {
	}
}
