<?php

namespace QuizPress\Admin;

if ( !defined( 'ABSPATH' ) ) {
    exit;
}
class License {
    public static function init() {
        $self = new self();
        add_action( 'admin_menu', array($self, 'add_freemius_submenu') );
        $self->load_freemius_sdk();
    }

    public function add_freemius_submenu() {
        $page_title = apply_filters( 'quizpress/admin/settings_sub_menu_title', __( 'QuizPress License', 'easy-content-manager' ) );
        add_submenu_page(
            'options-general.php',
            $page_title,
            $page_title,
            'manage_options',
            'quizpress-pro',
            '__return_false'
        );
    }

    public function load_freemius_sdk() {
        if ( !function_exists( 'quizpress_license' ) ) {
            // Create a helper function for easy SDK access.
            function quizpress_license() {
                global $quizpress_license;
                if ( !isset( $quizpress_license ) ) {
                    // Activate multisite network integration.
                    if ( !defined( 'WP_FS__PRODUCT_21433_MULTISITE' ) ) {
                        define( 'WP_FS__PRODUCT_21433_MULTISITE', true );
                    }
                    // Include Freemius SDK.
                    require_once QUIZPRESS_ROOT_DIR_PATH . 'library/freemius/start.php';
                    $quizpress_license = fs_dynamic_init( array(
                        'id'             => '21433',
                        'slug'           => 'quizpress',
                        'type'           => 'plugin',
                        'public_key'     => 'pk_bd28a30bc58567be82fa167e64568',
                        'is_premium'     => true,
                        'has_addons'     => false,
                        'has_paid_plans' => true,
                        'menu'           => array(
                            'slug'       => 'quizpress-pro',
                            'first-path' => 'admin.php?page=quizpress',
                            'support'    => false,
                            'parent'     => array(
                                'slug' => 'options-general.php',
                            ),
                        ),
                        'is_live'        => true,
                    ) );
                }
                return $quizpress_license;
            }

            // Init Freemius.
            quizpress_license();
            // Signal that SDK was initiated.
            do_action( 'quizpress_license_loaded' );
        }
    }

    //end if
}
