<?php
namespace QuizPress\Admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
use QuizPress\Helper;

class Menu {

	public static function init() {
		$self = new self();
		add_action( 'admin_menu', array( $self, 'admin_menu' ) );
	}

	/**
	 * Add admin menu page
	 *
	 * @return void
	 */
	public function admin_menu() {
		$icon_url = $this->get_toplevel_menu_icon_url();
		$page_title = $this->get_toplevel_menu_title();
		add_menu_page( $page_title, $page_title, 'manage_options', QUIZPRESS_PLUGIN_SLUG, [ $this, 'load_main_template' ], $icon_url, 2 );
		foreach ( Helper::get_admin_menu_list() as $item_key => $item ) {
			add_submenu_page( $item['parent_slug'], $item['title'], $item['title'], $item['capability'], $item_key, [ $this, 'load_main_template' ] );
		}
	}

	public function load_main_template() {
		echo '<div id="quizpresswrap" class="quizpresswrap"></div>';
	}

	public function get_toplevel_menu_title() {
		return apply_filters( 'quizpress/admin/toplevel_menu_title', __( 'QuizPress', 'quizpress' ) );
	}

	public function get_toplevel_menu_icon_url() {
		// phpcs:disable
		$icon_url = 'data:image/svg+xml;base64, ' . base64_encode( file_get_contents( QUIZPRESS_ASSETS_DIR_PATH . 'images/logo_black_white.svg' ) );
		return apply_filters( 'quizpress/admin/toplevel_inactive_menu_icon', $icon_url );
	}

	public function get_logo_url(){
		return apply_filters( 'quizpress/admin/logo_url',  QUIZPRESS_ASSETS_URI . 'images/logo_black_white.svg' );
	}

}