<?php
namespace QuizPress\Admin\Settings;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Base {
	public static function get_saved_data() {
		$settings = get_option( QUIZPRESS_SETTINGS_NAME );
		if ( $settings ) {
			return apply_filters( 'quizpress/admin/settings/saved_data', json_decode( $settings, true ) );
		}
		return [];
	}
	public static function get_default_data() {
		return apply_filters('quizpress/admin/settings/base_default_data', [
            // general settings
            'quizpress_questions_default_type' => 'single_choice',
            'quizpress_answer_default_count' => 5,
            'quizpress_questions_default_category' => 'uncategorized',
            'quizpress_wp_editor_height' => 200,
            'quizpress_public_textarea_height' => 200,
            'quizpress_question_title_view' => 'question_content',
            'is_enable_answers_allow_html_for_new_question' => true,
            'is_show_quiz_button_admins_only' => true,
            'is_enable_hide_question_text_for_new_question' => true,
            'is_enable_start_button_loader' => true,
            'is_disable_store_ip_address' => true,
            'quizpress_quiz_data_erase' => 2, // monthly
			'quizpress_primary_certificate_id' => 0,
			// custom field
			'quizpress_custom_field' => [

			],
			// role management
			'quizpress_quiz_role_management' =>  
			[
				'select_user_role_for_data_changes_access' => [
					'administrator' => true,
					'editor' => false,
					'quiz_manager' => true,
					'author' => false,
				]
			],
			// user details
			'quizpress_user_service_details' => 
			[
				'is_show_user_ip' => true,
				'is_show_user_id' => true,
				'is_show_user_email' => true,
				'is_show_user_name' => true,
				'is_show_user' => true,
				'is_show_start_date' => true,
				'is_show_duration' => true,
				'is_show_score' => true,
				'is_show_rating' => true,
			]
		]);
	}

	public static function save_settings( $form_data = false ) {
		$default_data = self::get_default_data();
		$saved_data = self::get_saved_data();
		$settings_data = wp_parse_args( $saved_data, $default_data );

		if ( $form_data ) {
			$settings_data = wp_parse_args( $form_data, $settings_data );
		}
		// if settings already saved, then update it
		if ( count( $saved_data ) ) {
			return update_option( QUIZPRESS_SETTINGS_NAME, wp_json_encode( $settings_data ) );
		}
		return add_option( QUIZPRESS_SETTINGS_NAME, wp_json_encode( $settings_data ) );
	}
}
