<?php
namespace  QuizPress\Ajax;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use QuizPress\Classes\AbstractAjaxHandler;
use QuizPress\Admin\Settings\Base as BaseSettings;
use QuizPress\Classes\Sanitizer;

class Settings extends AbstractAjaxHandler {
	public function __construct() {
		$this->actions = array(
			'update_base_settings' => array(
				'callback' => array( $this, 'update_base_settings' ),
				'capability' => 'manage_options' 
			),
		);
	}

	public function update_base_settings( $payload_data ) {
		// phpcs:ignore WordPress.Security.NonceVerification.Missing
		do_action( 'quizpress/admin/before_save_settings', $payload_data, 'base' );
		$payload = Sanitizer::sanitize_payload( apply_filters( 'quizpress/admin/settings/sanitize_payload', [
			'quizpress_questions_default_type' => 'string',
            'quizpress_answer_default_count' => 'integer',
            'quizpress_questions_default_category' => 'string',
            'quizpress_wp_editor_height' => 'integer',
            'quizpress_public_textarea_height' => 'integer',
            'quizpress_question_title_view' => 'string',
            'is_enable_answers_allow_html_for_new_question' => 'boolean',
            'is_show_quiz_button_admins_only' => 'boolean',
            'is_enable_hide_question_text_for_new_question' => 'boolean',
            'is_enable_start_button_loader' => 'boolean',
            'is_disable_store_ip_address' => 'boolean',
            'quizpress_quiz_data_erase' => 'integer',
			'quizpress_quiz_role_management' => 'object',
			'quizpress_quiz_role_management' => 'array',
			'quizpress_user_service_details' => 'array',
			'quizpress_primary_certificate_id' => 'integer',
		]), $payload_data );

		$default = BaseSettings::get_default_data();

		$is_update = BaseSettings::save_settings( apply_filters( 'quizpress/admin/settings/save', [
			'quizpress_questions_default_type'      => $payload['quizpress_questions_default_type'] ?? $default['quizpress_questions_default_type'],
			'quizpress_answer_default_count'        => $payload['quizpress_answer_default_count'] ?? $default['quizpress_answer_default_count'],
			'quizpress_questions_default_category'  => $payload['quizpress_questions_default_category'] ?? $default['quizpress_questions_default_category'],
			'quizpress_wp_editor_height'            => $payload['quizpress_wp_editor_height'] ?? $default['quizpress_wp_editor_height'],
			'quizpress_public_textarea_height'      => $payload['quizpress_public_textarea_height'] ?? $default['quizpress_public_textarea_height'],
			'quizpress_question_title_view'         => $payload['quizpress_question_title_view'] ?? $default['quizpress_question_title_view'],
			'is_enable_answers_allow_html_for_new_question' => $payload['is_enable_answers_allow_html_for_new_question'] ?? $default['is_enable_answers_allow_html_for_new_question'],
			'is_show_quiz_button_admins_only'       => $payload['is_show_quiz_button_admins_only'] ?? $default['is_show_quiz_button_admins_only'],
			'is_enable_hide_question_text_for_new_question' => $payload['is_enable_hide_question_text_for_new_question'] ?? $default['is_enable_hide_question_text_for_new_question'],
			'is_enable_start_button_loader'         => $payload['is_enable_start_button_loader'] ?? $default['is_enable_start_button_loader'],
			'is_disable_store_ip_address'           => $payload['is_disable_store_ip_address'] ?? $default['is_disable_store_ip_address'],
			'quizpress_quiz_data_erase'             => $payload['quizpress_quiz_data_erase'] ?? $default['quizpress_quiz_data_erase'],
			'quizpress_quiz_role_management'        => $payload['quizpress_quiz_role_management'] ?? $default['quizpress_quiz_role_management'],
			'quizpress_user_service_details'        => $payload['quizpress_user_service_details'] ?? $default['quizpress_user_service_details'],
			'quizpress_primary_certificate_id'      => $payload['quizpress_primary_certificate_id'] ?? $default['quizpress_primary_certificate_id'],
			
		], $payload, $default ) );
		do_action( 'quizpress/admin/after_save_settings', $is_update, 'base', $payload_data );
		wp_send_json_success( wp_parse_args($payload, $default) );
	}

}
