<?php
namespace QuizPress\API\Schema;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

trait AttemptsSchema {

	public function get_public_item_schema() {
		$schema = array(
			'$schema'              => 'http://json-schema.org/draft-04/schema#',
			'title'                => 'attempt',
			'type'                 => 'object',
			'properties'           => array(
				'attempt_id' => array(
					'description'  => esc_html__( 'Unique identifier for the quiz attempt.', 'quizpress' ),
					'type'         => 'integer',
					'context'      => array( 'view', 'edit', 'embed' ),
					'readonly'     => true,
				),
				'quiz_id' => array(
					'description'  => esc_html__( 'The id of the quizpress_quizzes post_type', 'quizpress' ),
					'type'         => 'integer',
				),
				'user_id' => array(
					'description'  => esc_html__( 'The id of the user ID', 'quizpress' ),
					'type'         => 'integer',
				),
				'total_questions' => array(
					'description'  => esc_html__( 'Total Questions', 'quizpress' ),
					'type'         => 'integer',
				),
				'total_answered_questions' => array(
					'description'  => esc_html__( 'Total Answered Questions', 'quizpress' ),
					'type'         => 'integer',
				),
				'total_marks' => array(
					'description'  => esc_html__( 'Total Marks', 'quizpress' ),
					'type'         => 'decimal',
				),
				'earned_marks' => array(
					'description'  => esc_html__( 'Total Earned Marks', 'quizpress' ),
					'type'         => 'decimal',
				),
				'attempt_info' => array(
					'description'  => esc_html__( 'Attempt Info.', 'quizpress' ),
					'type'         => 'string',
				),
				'attempt_status' => array(
					'description'  => esc_html__( 'Attempt Status.', 'quizpress' ),
					'type'         => 'string',
				),
				'attempt_ip' => array(
					'description'  => esc_html__( 'Attempt IP.', 'quizpress' ),
					'type'         => 'string',
				),
				'attempt_started_at' => array(
					'description'  => esc_html__( 'The creation time for the attempt.', 'quizpress' ),
					'type'         => 'string',
				),
				'attempt_ended_at' => array(
					'description'  => esc_html__( 'The updated time for the attempt.', 'quizpress' ),
					'type'         => 'string',
				),
			),
		);
		return $schema;
	}
	public function get_item_schema() {
		return [
			'attempt_id'           => [
				'type'              => 'integer',
				'sanitize_callback' => 'absint',
				'validate_callback' => 'rest_validate_request_arg',
			],
			'quiz_id'               => [
				'type'              => 'integer',
				'required'          => true,
				'sanitize_callback' => 'absint',
				'validate_callback' => 'rest_validate_request_arg',
			],
			'user_id'               => [
				'type'              => 'integer',
				'required'          => true,
				'sanitize_callback' => 'absint',
				'validate_callback' => 'rest_validate_request_arg',
			],
			'total_questions'               => [
				'type'              => 'integer',
				'sanitize_callback' => 'absint',
				'validate_callback' => 'rest_validate_request_arg',
			],
			'total_answered_questions'              => [
				'type'              => 'integer',
				'sanitize_callback' => 'absint',
				'validate_callback' => 'rest_validate_request_arg',
			],
			'total_marks'               => [
				'type'              => 'decimal',
				'sanitize_callback' => 'absint',
				'validate_callback' => 'rest_validate_request_arg',
			],
			'earned_marks'              => [
				'type'              => 'decimal',
				'sanitize_callback' => 'absint',
				'validate_callback' => 'rest_validate_request_arg',
			],
			'attempt_info'         => [
				'type'   => 'object',
			],
			'attempt_status'         => [
				'type'   => 'string',
				'sanitize_callback' => 'sanitize_text_field',
				'validate_callback' => 'rest_validate_request_arg',
			],
			'attempt_ip'         => [
				'type'   => 'string',
				'sanitize_callback' => 'sanitize_text_field',
				'validate_callback' => 'rest_validate_request_arg',
			],
			'attempt_started_at'     => [
				'type'   => 'string',
				'format' => 'date-time',
				'sanitize_callback' => 'sanitize_text_field',
			],
			'answer_ended_at'     => [
				'type'   => 'string',
				'format' => 'date-time',
				'sanitize_callback' => 'sanitize_text_field',
			],
		];
	}
	public function get_collection_params() {
		return array(
			'page'     => array(
				'description'       => __( 'Current page of the collection.', 'quizpress' ),
				'type'              => 'integer',
				'default'           => 1,
				'sanitize_callback' => 'absint',
				'validate_callback' => 'rest_validate_request_arg',
				'minimum'           => 1,
			),
			'per_page' => array(
				'description'       => __( 'Maximum number of items to be returned in result set.', 'quizpress' ),
				'type'              => 'integer',
				'default'           => 10,
				'minimum'           => 1,
				'maximum'           => 100,
				'sanitize_callback' => 'absint',
				'validate_callback' => 'rest_validate_request_arg',
			),
			'quiz_id'   => array(
				'description'       => __( 'Get attemps by quiz_id', 'quizpress' ),
				'type'              => 'integer',
				'sanitize_callback' => 'absint',
				'validate_callback' => 'rest_validate_request_arg',
			),
			'search'   => array(
				'description'       => __( 'Limit results to those matching a string.', 'quizpress' ),
				'type'              => 'string',
				'sanitize_callback' => 'sanitize_text_field',
				'validate_callback' => 'rest_validate_request_arg',
			),
		);
	}
}
