<?php

namespace QuizPress\API;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


use WP_REST_Controller;
use WP_REST_Server;
use QuizPress\Admin\Settings\Base as BaseSettings;

class Settings extends WP_REST_Controller {

	/**
	 * Initialize hooks and option name
	 */
	public static function init() {
		$self            = new self();
		$self->namespace = QUIZPRESS_PLUGIN_SLUG . '/v1';
		$self->rest_base = 'settings';
		add_action( 'rest_api_init', array( $self, 'register_routes' ) );
		add_action( 'quizpress/admin/after_save_settings', array( $self, 'after_save_settings' ) );
	}

	/**
	 * Register the routes for the objects of the controller.
	 */
	public function register_routes() {
		$endpoint = '/settings/';

		register_rest_route(
			$this->namespace,
			$endpoint,
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array( $this, 'get_items' ),
					'permission_callback' => array( $this, 'get_items_permissions_check' ),
					'args'                => array(),
				),
			)
		);
	}

	public function get_items( $request ) {
		$settings = BaseSettings::get_saved_data();

		$response = apply_filters( 'quizpress/api/settings/get_settings', $settings );

		return rest_ensure_response( $response );
	}

	public function get_items_permissions_check( $request ) {
		return current_user_can( 'manage_options' );
	}

	public function after_save_settings( $is_update ) {
		if ( $is_update ) {
			update_option( 'quizpress_flash_role_management', true );
		}
	}
}
