<?php

namespace QuizPress;

if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

class Assets
{
	public static function init()
	{
		$self = new self();
		add_action('admin_enqueue_scripts', [$self, 'backend_scripts']);
		add_action('wp_enqueue_scripts', [$self, 'frontend_scripts']);
	}

	private function get_scripts_data()
	{
		global $quizpress_addons;
		return array(
			'nonce'                 => wp_create_nonce('wp_rest'),
			'quizpress_nonce'         => wp_create_nonce('quizpress_nonce'),
			'rest_url'              => rest_url(),
			'namespace'             => QUIZPRESS_PLUGIN_SLUG . '/v1/',
			'plugin_root_url'       => QUIZPRESS_PLUGIN_ROOT_URI,
			'plugin_root_path'      => QUIZPRESS_ROOT_DIR_PATH,
			'ajaxurl'               => esc_url(admin_url('admin-ajax.php')),
			'site_url'              => site_url(),
			'admin_url'				=> admin_url(),
			'addons'			 	=> $quizpress_addons,
			'route_path'            => wp_parse_url(admin_url(), PHP_URL_PATH),
			'menu'                  => wp_json_encode(Helper::get_admin_menu_list()),
			'is_plain_permalink'    => (bool) empty(get_option('permalink_structure')),
			'is_pro'                => true,
			'is_admin'				=> (bool) current_user_can('manage_options'),
			'certificate_url'       => esc_url( add_query_arg( array( 'source' => 'qp-certificate' ), get_the_permalink() ) ),
		);
	}

	private function get_backend_scripts_data()
	{
		return apply_filters('quizpress/assets/backend_scripts_data', $this->get_scripts_data());
	}

	private function get_frontend_scripts_data()
	{
		$site_url = site_url();
		return apply_filters(
			'quizpress/assets/fronted_scripts_data',
			array_merge(
				$this->get_scripts_data(),
				array(
					'route_path' => wp_parse_url($site_url, PHP_URL_PATH),
					'admin_url'  => admin_url(),
					'user_id'    => get_current_user_id(),
				)
			)
		);
	}

	/**
	 * Enqueue Files on Start Plugin
	 *
	 * @param string $hook
	 * @function backend_scripts
	 */
	public function backend_scripts($hook)
	{
		if ( strpos( $hook, '_page_' . QUIZPRESS_PLUGIN_SLUG ) !== false ) {
			remove_all_actions( 'admin_notices' );
			// js
			$dependencies = include_once QUIZPRESS_ASSETS_DIR_PATH . 'build/backend.asset.php';
			if (! did_action('wp_enqueue_media')) {
				wp_enqueue_media();
			}
			wp_enqueue_style('quizpress-admin-style', QUIZPRESS_ASSETS_URI . 'build/backend.css', array('wp-components'), filemtime(QUIZPRESS_ASSETS_DIR_PATH . 'build/backend.css'), 'all');
			wp_enqueue_style('quizpress-icon', QUIZPRESS_ASSETS_URI . 'lib/css/quizpress-icon/style.css', array(), filemtime(QUIZPRESS_ASSETS_DIR_PATH . 'lib/css/quizpress-icon/style.css'), 'all');
			wp_enqueue_script(
				'quizpress-admin-scripts',
				QUIZPRESS_ASSETS_URI . 'build/backend.js',
				$dependencies['dependencies'],
				$dependencies['version'],
				true
			);
			wp_localize_script('quizpress-admin-scripts', 'QuizPressGlobal', $this->get_backend_scripts_data());
			wp_set_script_translations('quizpress-admin-scripts', 'quizpress', QUIZPRESS_ROOT_DIR_PATH . 'languages/');
		}
	}
	/**
	 * Enqueue Files on Start Plugin
	 *
	 * @function frontend_scripts
	 */
	public function frontend_scripts()
	{
		wp_register_style(
			'quizpress-frontend-style',
			QUIZPRESS_ASSETS_URI . 'build/frontend.css',
			[],
			'',
			'all'
		);
		wp_register_style('quizpress-frontend-icon', QUIZPRESS_ASSETS_URI . 'lib/css/quizpress-icon/style.css', array(), filemtime(QUIZPRESS_ASSETS_DIR_PATH . 'lib/css/quizpress-icon/style.css'), 'all');


		$dependencies = include_once QUIZPRESS_ASSETS_DIR_PATH . 'build/frontend.asset.php';
		wp_register_script(
			'quizpress-frontend-scripts',
			QUIZPRESS_ASSETS_URI . 'build/frontend.js',
			$dependencies['dependencies'],
			$dependencies['version'],
			true
		);

		if ( ! did_action( 'wp_enqueue_media' ) ) {	
			wp_enqueue_media();
		}

		wp_localize_script('quizpress-frontend-scripts', 'QuizPressGlobal', $this->get_frontend_scripts_data());
		wp_set_script_translations('quizpress-frontend-scripts', 'quizpress', QUIZPRESS_ROOT_DIR_PATH . 'languages/');
	}
}
