<?php
namespace QuizPress\Classes;

use QuizPress\Classes\ExportBase;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class QuestionExport extends ExportBase {
	public function get_questions_for_export() {
		$question_array = [];

		$empty_question = array(
			'question_title' => '',
			'question_type' => '',
			'question_points' => '',
			'question_content' => '',
			'question_explanation' => '',
			'question_status' => '',
			'question_display_points' => '',
			'question_answer_required' => '',
			'question_randomize' => '',
			'question_order' => '',
		);

		$empty_answer = array(
			'answer_title' => '',
			'answer_content' => '',
			'is_correct' => '',
			'answer_order' => '',
		);

		$questions = $this->get_all_questions();
		if ( count( $questions ) ) {
			foreach ( $questions as $question ) {
				$settings = json_decode( $question->question_settings );
                $question_array[] = array(
                    'question_title' => $question->question_title,
                    'question_type' => $question->question_type,
					'answer_type' => $question->answer_type,
                    'question_score' => $question->question_score,
                    'question_content' => $question->question_content,
                    'question_explanation' => $question->question_explanation,
                    'question_status' => $question->question_status,
                    'question_order' => $question->question_order,
					'question_negative_score' => $question->question_negative_score,
                    'question_display_points' => $settings->display_points,
                    'question_answer_required' => $settings->answer_required,
                    'question_random_answer' => $settings->random_answer,
                );

                $question_answers = $this->get_question_answers( $question->question_id );
                foreach ( $question_answers as $question_answer ) {
                    $question_array[] = $question_answer;
                }
			}//end foreach

			return $question_array;
		}//end if

		return array( $empty_question, $empty_answer );
	}


	public function get_question_answers( $question_id ) {
		global $wpdb;
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
		$answers = $wpdb->get_results(
			$wpdb->prepare(
				"SELECT answer_title, is_correct, answer_content, image_id, answer_order  FROM {$wpdb->prefix}quizpress_answers WHERE question_id=%d",
				$question_id
			),
			OBJECT
		);

		$prepare_answers = [];

		foreach ( $answers as $answer ) {
			$prepare_answers[] = [
				'answer_title' => $answer->answer_title,
				'answer_content' => $answer->answer_content,
				'is_correct' => $answer->is_correct,
                'answer_order' => $answer->answer_order,
				// phpcs:ignore Squiz.PHP.CommentedOutCode.Found
				// 'answer_image_id' => $answer->image_id,
			];
		}

		return $prepare_answers;
	}

	public function get_all_questions() {
		global $wpdb;
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
		return $wpdb->get_results(
			$wpdb->prepare(
				"SELECT * FROM {$wpdb->prefix}quizpress_questions WHERE question_status=%s",
                'publish'
			)
		);

	}

	/**
	 * Method Overwrite
	 *
	 * Overwrite export base class method
	 *
	 * @param array          $array
	 * @param resource|false $fp
	 * @return void
	 */
	public function write_nested_csv( $array, $fp ) {
		$previousItem = array();
		foreach ( $array as $row ) {
			$flattenRow = $this->flatten_array( $row );
			if ( isset( $flattenRow['question_title'] ) || ( isset( $flattenRow['answer_title'] ) && ! isset( $previousItem['answer_title'] ) ) ) {
				$row_header = array_keys( $flattenRow );
				fputcsv( $fp, $row_header );
			}
			fputcsv( $fp, $flattenRow );
			$previousItem = $row;
		}
	}
}
