<?php
namespace QuizPress\Classes;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Role {
	public static function add_manager_role() {
		remove_role( 'quizpress_manager' );
		add_role( 'quizpress_manager', esc_html__( 'QuizPress Manager', 'quizpress' ), array() );
		$role_permission = array(
			'edit_quizpress_quiz',
			'edit_quizpress_quizzess',
			'edit_others_quizpress_quizzes',
			'publish_quizpress_quizzes',
			'edit_post',
			'edit_posts',
			'edit_post_meta',
			'read',
			'read_quizpress_quiz'
		);
		$student = get_role( 'quizpress_manager' );
		if ( $student ) {
			foreach ( $role_permission as $cap ) {
				$student->add_cap( $cap );
			}
		}
	}

	public static function add_user_role() {
		remove_role( 'quizpress_user' );
		add_role( 'quizpress_user', esc_html__( 'QuizPress User', 'quizpress' ), array() );
		$role_permission = array(
			'read',
			'read_quizpress_quiz'
		);
		$student = get_role( 'quizpress_manager' );
		if ( $student ) {
			foreach ( $role_permission as $cap ) {
				$student->add_cap( $cap );
			}
		}
	}

	public static function add_admin_role() {
		$role_permission = array(
			// quizzes
			'edit_quizpress_quiz',
			'read_quizpress_quiz',
			'delete_quizpress_quiz',
            'delete_quizpress_quizzes',
            'edit_quizpress_quizzess',
			'edit_others_quizpress_quizzes',
			'publish_quizpress_quizzes',
			'read_private_quizpress_quizzes',
			'edit_quizpress_quizzes',
			// common
			'edit_post',
			'edit_post_meta',
			'assign_terms',
			'assign_term',
			'read',
			'upload_files',
			'edit_posts',
            'edit_others_post',
		);

		$administrator = get_role( 'administrator' );
		if ( $administrator ) {
			foreach ( $role_permission as $cap ) {
				$administrator->add_cap( $cap );
			}
		}
	}
}
