<?php
namespace QuizPress\Database;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class CreateAnswersTable {

	public static function up( $prefix, $charset_collate ) {
		$table_name = $prefix . QUIZPRESS_PLUGIN_SLUG . '_answers';
		$sql        = "CREATE TABLE IF NOT EXISTS $table_name (
            answer_id bigint(20) unsigned NOT NULL auto_increment,
            question_id bigint(20) DEFAULT NULL,
			answer_title text NOT NULL,
			answer_points bigint(20) DEFAULT 0,
            answer_content longtext NULL,
			is_correct tinyint(1) NOT NULL,
			image_id bigint(20) DEFAULT NULL,
			view_format varchar(20) DEFAULT NULL,
			answer_order int(11) NOT NULL,
			answer_created_at datetime DEFAULT NULL,
			answer_updated_at datetime DEFAULT NULL,
			PRIMARY KEY  (answer_id)
        ) $charset_collate;";
		dbDelta( $sql );
	}
}
