<?php
namespace QuizPress;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use QuizPress\Classes\Role;
use QuizPress\Admin\Settings;

class Installer {
	
	public $quizpress_version;
	public static function init() {
		$self = new self();
		$self->quizpress_version = get_option( 'quizpress_version' );
		Database::create_initial_custom_table();
		$self->add_role();
		$self->save_main_settings();
		$self->save_option();
	}

	public function add_role() {
		// user role
		Role::add_user_role();
		// manager role
		Role::add_manager_role();
		// admin role
		Role::add_admin_role();
	}

	public function save_main_settings() {
		Settings::save_settings();
	}
	public function save_option() {
		if ( ! $this->quizpress_version ) {
			add_option( 'quizpress_version', QUIZPRESS_VERSION );
		}
		if ( ! get_option( 'quizpress_db_version' ) ) {
			add_option( 'quizpress_db_version', QUIZPRESS_DB_VERSION );
		}
		if ( ! get_option( 'quizpress_first_install_time' ) ) {
			add_option( 'quizpress_first_install_time', Helper::get_time() );
		}
		update_option( 'quizpress_required_rewrite_flush', Helper::get_time() );
		update_option( 'quizpress_flash_role_management', true );
	}
}
